/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.SettleDetailEntity;
import com.ejianc.business.jlincome.income.bean.SettleEntity;
import com.ejianc.business.jlincome.income.mapper.SettleMapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.ISettleDetailService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.vo.SettleDetailVO;
import com.ejianc.business.jlincome.income.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private static final String BILL_CODE = "DJJSC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private IContractRegisterService contractRegisterService;

    @Override
    public CommonResponse<SettleVO> saveOrUpdate(SettleVO saveOrUpdateVO) {
        this.querySettleByContractId(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId() != null ? saveOrUpdateVO.getId() : null);
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<SettleDetailEntity> detailList = entity.getDetailList();
            boolean upFlag = false;
            BigDecimal detailTaxMny = BigDecimal.ZERO;
            BigDecimal detailMny = BigDecimal.ZERO;
            BigDecimal detailTax = BigDecimal.ZERO;
            for (SettleDetailEntity item : detailList) {
                if (null != item.getRowState() && item.getRowState().equals("del")) continue;
                upFlag = true;
                detailTaxMny = ComputeUtil.safeAdd((BigDecimal)detailTaxMny, (BigDecimal)item.getDetailTaxMny());
                detailMny = ComputeUtil.safeAdd((BigDecimal)detailMny, (BigDecimal)item.getDetailMny());
                detailTax = ComputeUtil.safeAdd((BigDecimal)detailTax, (BigDecimal)item.getDetailTax());
            }
            if (upFlag) {
                entity.setContractDetailTaxMny(detailTaxMny);
                entity.setContractDetailMny(detailMny);
                entity.setContractDetailTax(detailTax);
                BigDecimal lastTaxMny = entity.getLastTaxMny();
                BigDecimal lastMny = entity.getLastMny();
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                BigDecimal totalTaxMny = BigDecimal.ZERO;
                BigDecimal totalMny = BigDecimal.ZERO;
                taxMny = ComputeUtil.safeSub((BigDecimal)entity.getContractDetailTaxMny(), (BigDecimal)entity.getFirstDeductionTaxMny());
                taxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)entity.getDetailOtherTaxMny());
                mny = ComputeUtil.safeSub((BigDecimal)entity.getContractDetailMny(), (BigDecimal)entity.getFirstDeductionMny());
                mny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)entity.getDetailOtherMny());
                tax = ComputeUtil.safeSub((BigDecimal)entity.getContractDetailTax(), (BigDecimal)entity.getFirstDeductionTax());
                tax = ComputeUtil.safeAdd((BigDecimal)tax, (BigDecimal)entity.getDetailOtherTax());
                totalTaxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)lastTaxMny);
                totalMny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)lastMny);
                entity.setTaxMny(taxMny);
                entity.setMny(mny);
                entity.setTax(tax);
                entity.setTotalTaxMny(totalTaxMny);
                entity.setTotalMny(totalMny);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<SettleVO> querySettle(Long contractId) {
        this.querySettleByContractId(contractId, null);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = super.list((Wrapper)queryWrapper);
        SettleVO settleVO = new SettleVO();
        settleVO.setTotalTicketTaxMny(BigDecimal.ZERO);
        settleVO.setTotalTicketMny(BigDecimal.ZERO);
        settleVO.setTotalAccountTaxMny(BigDecimal.ZERO);
        settleVO.setTotalAccountMny(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal lastTaxMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settleVO.setLastTaxMny(lastTaxMny);
            settleVO.setLastMny(lastMny);
            settleVO.setTotalTaxMny(lastTaxMny);
            settleVO.setTotalMny(lastMny);
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setTotalTaxMny(BigDecimal.ZERO);
            settleVO.setTotalMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)settleVO);
    }

    @Override
    public CommonResponse<Map<Long, SettleDetailVO>> querySettleDetail(List<String> sourceDetailIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_detail_id", sourceDetailIds);
        List list = this.detailService.list((Wrapper)queryWrapper);
        Map<Long, List<SettleDetailEntity>> collect = list.stream().collect(Collectors.groupingBy(SettleDetailEntity::getSourceDetailId));
        HashMap<Long, SettleDetailVO> map = new HashMap<Long, SettleDetailVO>();
        for (Map.Entry<Long, List<SettleDetailEntity>> entry : collect.entrySet()) {
            List<SettleDetailEntity> value = entry.getValue();
            BigDecimal lastTaxMny = value.stream().map(SettleDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastTax = value.stream().map(SettleDetailEntity::getDetailTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastMny = value.stream().map(SettleDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastNum = value.stream().map(SettleDetailEntity::getDetailSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            SettleDetailVO valueVO = new SettleDetailVO();
            valueVO.setDetailLastTaxMny(lastTaxMny);
            valueVO.setDetailLastMny(lastMny);
            valueVO.setDetailLastTax(lastTax);
            valueVO.setDetailLastNum(lastNum);
            valueVO.setDetailTotalTaxMny(lastTaxMny);
            valueVO.setDetailTotalMny(lastMny);
            valueVO.setDetailTotalTax(lastTax);
            valueVO.setDetailTotalNum(lastNum);
            map.put(entry.getKey(), valueVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @Override
    public void querySettleByContractId(Long contractId, Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        if (null != id) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = super.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4e2a\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
        }
    }

    @Override
    public JSONObject querySettleRecordByContId(Long contractId) {
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleTaxMny = settleVOS.stream().filter(p -> p.getTaxMny() != null).map(SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            jsonObject.put("sumSettleMny", (Object)sumSettleTaxMny);
            jsonObject.put("sumSettleScale", (Object)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()), (BigDecimal)BigDecimal.valueOf(100L)));
            jsonObject.put("detailList", (Object)settleVOS);
        }
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> querySettleRecordByContIdList(List<Long> contractIds) {
        HashMap<Long, JSONObject> collectMap = new HashMap<Long, JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SettleEntity::getContractId, contractIds);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<SettleEntity>> settleMap = list.stream().collect(Collectors.groupingBy(SettleEntity::getContractId));
            for (Long contractId : settleMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                List settleVOS = BeanMapper.mapList((Iterable)settleMap.get(contractId), SettleVO.class);
                BigDecimal sumSettleTaxMny = settleVOS.stream().filter(p -> p.getTaxMny() != null).map(SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                jsonObject.put("sumSettleTaxMny", (Object)sumSettleTaxMny);
                jsonObject.put("settleList", (Object)settleVOS);
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}

