/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlcost.finance.vo.InvoicePoolVO;
import com.ejianc.business.jlcost.finance.vo.ReceivePoolVO;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.bean.SaleContractEntity;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.service.IForecastDetailService;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.service.ISaleContractService;
import com.ejianc.business.jlincome.performance.service.impl.ForecastDetailServiceImpl;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.business.jlincome.performance.vo.ForecastReportVO;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"forecast"})
public class ForecastController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ForecastDetailServiceImpl forecastDetailService;
    private static final String BILL_CODE = "FORECAST_CODE";
    @Autowired
    private IForecastService service;
    @Autowired
    private IForecastDetailService detailService;
    @Autowired
    private SaleReportMapper saleReportMapper;
    @Autowired
    private ISaleContractService saleContractService;
    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ForecastVO> saveOrUpdate(@RequestBody ForecastVO saveOrUpdateVO) {
        return this.service.insertOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastVO> queryChangeDetail(Long id) {
        ForecastVO changeVO = this.service.queryChangeDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastVO> vos) {
        return this.service.deleteVos(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ForecastVO a = new ForecastVO();
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ForecastVO.class);
        voList.forEach(vo -> {
            if (vo.getChangeState() == 0) {
                vo.setChangeStateName("\u672a\u53d8\u66f4");
            } else if (vo.getChangeState() == 1) {
                vo.setChangeStateName("\u53d8\u66f4\u4e2d");
            } else {
                vo.setChangeStateName("\u5df2\u53d8\u66f4");
            }
        });
        this.logger.info(((ForecastVO)voList.get(0)).getChangeStateName());
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Forecast-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refForecastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> refForecastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkOrgMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkOrgMonth(@RequestParam(value="rowId", required=false) Long rowId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="forecastMonth") String forecastMonth) {
        return this.service.checkOrgMonth(rowId, orgId, forecastMonth);
    }

    @RequestMapping(value={"/queryLedgerList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastLedgerVO>> queryLedgerList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("enableState", new Parameter("eq", (Object)true));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList();
        resDatas = BeanMapper.mapList((Iterable)page.getRecords(), ForecastLedgerVO.class);
        HashMap<Long, ForecastLedgerVO> oneMap = new HashMap<Long, ForecastLedgerVO>();
        if (CollectionUtils.isNotEmpty(resDatas)) {
            resDatas.forEach(e -> oneMap.put(e.getId(), (ForecastLedgerVO)e));
        }
        List<ForecastLedgerVO> res = null;
        if (!oneMap.isEmpty()) {
            res = this.getList(oneMap, resDatas);
            List forecastLedgerVOS = TreeNodeBUtil.buildTree(res);
            pageData.setRecords(forecastLedgerVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(new ArrayList());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        List<ForecastReportVO> detialList;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ForecastReportVO> resList = this.service.queryListAll(page, wrapper);
        if (CollectionUtils.isNotEmpty(resList) && CollectionUtils.isNotEmpty(detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList())))) {
            resList.addAll(detialList);
        }
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ForecastReportVO> resList = this.service.queryListAll(page, wrapper);
        List<ForecastReportVO> detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(detialList)) {
            resList.addAll(detialList);
        }
        ArrayList list = new ArrayList();
        List res = TreeNodeBUtil.buildTree(resList);
        res.forEach(e -> {
            list.add(e);
            if (CollectionUtils.isNotEmpty((Collection)e.getChildren())) {
                list.addAll(e.getChildren());
                e.getChildren().forEach(i -> {
                    list.add(i);
                    if (CollectionUtils.isNotEmpty((Collection)i.getChildren())) {
                        list.addAll(i.getChildren());
                    }
                });
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList(list, ForecastReportVO.class));
        ExcelExport.getInstance().export("ForecastReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/reportList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse reportList(String year) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ForecastEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        wrapper.in(ForecastEntity::getEnableState, new Object[]{true});
        wrapper.between(ForecastEntity::getForecastMonth, (Object)(year + "-01-01"), (Object)(year + "-12-31"));
        List forecasts = this.service.list((Wrapper)wrapper);
        ArrayList<ForecastLedgerVO> oneList = new ArrayList<ForecastLedgerVO>();
        for (int i = 0; i < 12; ++i) {
            ForecastLedgerVO forecastLedgerVO = new ForecastLedgerVO();
            forecastLedgerVO.setSaleForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setInvoiceForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setIncomeForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setSaleCompletionMny(BigDecimal.ZERO);
            forecastLedgerVO.setInvoiceCompletionMny(BigDecimal.ZERO);
            forecastLedgerVO.setIncomeCompletionMny(BigDecimal.ZERO);
            oneList.add(forecastLedgerVO);
        }
        forecasts.forEach(forecast -> {
            Integer month = forecast.getForecastMonth().getMonth();
            ForecastLedgerVO forecastLedgerVO = (ForecastLedgerVO)oneList.get(month - 1);
            forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleForecastMny().add(forecast.getSaleForecastMny()));
            forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceForecastMny().add(forecast.getInvoiceForecastMny()));
            forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeForecastMny().add(forecast.getIncomeForecastMny()));
            oneList.set(month - 1, forecastLedgerVO);
        });
        ArrayList resList = new ArrayList();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(SaleContractEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        lambda.between(SaleContractEntity::getRegisterDate, (Object)(year + "-01-01"), (Object)(year + "-12-31"));
        List contracts = this.saleContractService.list((Wrapper)lambda);
        contracts.forEach(contract -> {
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(contract.getRegisterDate()));
            ForecastLedgerVO forecastLedgerVO = (ForecastLedgerVO)oneList.get(month - 1);
            forecastLedgerVO.setSaleCompletionMny(forecastLedgerVO.getSaleCompletionMny().add(contract.getContractMny()).divide(BigDecimal.valueOf(10000L)));
            this.logger.info("\u9500\u552e\u5b8c\u6210\uff1a{},{}", (Object)month, (Object)contract.getContractMny());
        });
        CommonResponse res = this.invoiceReceiveApi.getDataPool();
        if (!res.isSuccess()) {
            this.logger.info("\u62bd\u53d6\u5f00\u7968\u6536\u6b3e\u6570\u636e\u5931\u8d25--" + res.getMsg());
            throw new BusinessException("\u62bd\u53d6\u5f00\u7968\u6536\u6b3e\u6570\u636e\u5931\u8d25\uff01\u539f\u56e0-" + res.getMsg());
        }
        List invoices = (List)((JSONObject)res.getData()).get((Object)"invoiceDetailList");
        ObjectMapper mapper = new ObjectMapper();
        List invoiceEntities2 = (List)mapper.convertValue((Object)invoices, (TypeReference)new TypeReference<List<InvoicePoolVO>>(){});
        invoiceEntities2.forEach(invoice -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
            if (!dateFormat.format(invoice.getInvoiceDate()).equals(year)) {
                return;
            }
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(invoice.getInvoiceDate()));
            ForecastLedgerVO forecastLedgerVO = (ForecastLedgerVO)oneList.get(month - 1);
            forecastLedgerVO.setInvoiceCompletionMny(forecastLedgerVO.getInvoiceCompletionMny().add(invoice.getInvoiceMny()).divide(BigDecimal.valueOf(10000L)));
            oneList.set(month - 1, forecastLedgerVO);
            this.logger.info("\u5f00\u7968\u5b8c\u6210\uff1a{},{}", (Object)month, (Object)invoice.getInvoiceMny());
        });
        List incomes = (List)((JSONObject)res.getData()).get((Object)"receiveDetailList");
        List receivePoolVOS = (List)mapper.convertValue((Object)incomes, (TypeReference)new TypeReference<List<ReceivePoolVO>>(){});
        receivePoolVOS.forEach(income -> {
            SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
            if (!yearFormat.format(income.getReceiveTime()).equals(year)) {
                return;
            }
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(income.getReceiveTime()));
            ForecastLedgerVO forecastLedgerVO = (ForecastLedgerVO)oneList.get(month - 1);
            forecastLedgerVO.setIncomeCompletionMny(forecastLedgerVO.getIncomeCompletionMny().add(income.getReceiveMny()).divide(BigDecimal.valueOf(10000L)));
            oneList.set(month - 1, forecastLedgerVO);
            this.logger.info("\u6536\u6b3e\u5b8c\u6210\uff1a{},{}", (Object)month, (Object)income.getReceiveMny());
        });
        return CommonResponse.success(oneList);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ForecastLedgerVO>> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("enableState", new Parameter("eq", (Object)true));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        List<ForecastLedgerVO> resDatas = new ArrayList();
        resDatas = BeanMapper.mapList((Iterable)page.getRecords(), ForecastLedgerVO.class);
        HashMap<Long, ForecastLedgerVO> oneMap = new HashMap<Long, ForecastLedgerVO>();
        if (CollectionUtils.isNotEmpty(resDatas)) {
            resDatas.forEach(e -> oneMap.put(e.getId(), (ForecastLedgerVO)e));
        }
        List<ForecastLedgerVO> res = null;
        ArrayList resList = new ArrayList();
        if (!oneMap.isEmpty()) {
            res = this.getList(oneMap, resDatas);
            res.forEach(e -> {
                if (null == e.getParentId()) {
                    resList.add(e);
                }
            });
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", resList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", new ArrayList());
    }

    @RequestMapping(value={"/LedgerExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void LedgerExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("enableState", new Parameter("eq", (Object)true));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), ForecastLedgerVO.class);
            HashMap<Long, ForecastLedgerVO> oneMap = new HashMap<Long, ForecastLedgerVO>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> oneMap.put(e.getId(), (ForecastLedgerVO)e));
            }
            List<ForecastLedgerVO> res = null;
            if (!oneMap.isEmpty()) {
                res = this.getList(oneMap, resDatas);
                ForecastController.export(response, res);
            } else {
                ForecastController.export(response, res);
            }
        }
    }

    private static void export(HttpServletResponse response, List<ForecastLedgerVO> res) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        ArrayList<ForecastLedgerVO> forecastLedgerVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty(res)) {
            forecastLedgerVOS = TreeNodeBUtil.buildTree(res);
        }
        beans.put("records", forecastLedgerVOS);
        ForecastController.extracted(forecastLedgerVOS, beans);
        ExcelExport.getInstance().export("Ledger-export.xlsx", beans, response);
    }

    private static void extracted(List<ForecastLedgerVO> resDatas, Map<String, Object> beans) {
        BigDecimal saleForecastMny = new BigDecimal(0);
        BigDecimal invoiceForecastMny = new BigDecimal(0);
        BigDecimal incomeForecastMny = new BigDecimal(0);
        BigDecimal saleCompletionMny = new BigDecimal(0);
        BigDecimal saleCompletionGap = new BigDecimal(0);
        BigDecimal invoiceCompletionMny = new BigDecimal(0);
        BigDecimal invoiceCompletionGap = new BigDecimal(0);
        BigDecimal incomeCompletionMny = new BigDecimal(0);
        BigDecimal incomeCompletionGap = new BigDecimal(0);
        for (ForecastLedgerVO resData : resDatas) {
            saleForecastMny = saleForecastMny.add(resData.getSaleForecastMny());
            invoiceForecastMny = invoiceForecastMny.add(resData.getInvoiceForecastMny());
            incomeForecastMny = incomeForecastMny.add(resData.getIncomeForecastMny());
            saleCompletionMny = saleCompletionMny.add(resData.getSaleCompletionMny());
            saleCompletionGap = saleCompletionGap.add(resData.getSaleCompletionGap());
            invoiceCompletionMny = invoiceCompletionMny.add(resData.getInvoiceCompletionMny());
            invoiceCompletionGap = invoiceCompletionGap.add(resData.getInvoiceCompletionGap());
            incomeCompletionMny = incomeCompletionMny.add(resData.getIncomeCompletionMny());
            incomeCompletionGap = incomeCompletionGap.add(resData.getIncomeCompletionGap());
        }
        beans.put("saleForecastMny", saleForecastMny);
        beans.put("invoiceForecastMny", invoiceForecastMny);
        beans.put("incomeForecastMny", incomeForecastMny);
        beans.put("saleCompletionMny", saleCompletionMny);
        beans.put("saleCompletionGap", saleCompletionGap);
        beans.put("invoiceCompletionMny", invoiceCompletionMny);
        beans.put("invoiceCompletionGap", invoiceCompletionGap);
        beans.put("incomeCompletionMny", incomeCompletionMny);
        beans.put("incomeCompletionGap", incomeCompletionGap);
    }

    private List<ForecastLedgerVO> getList(Map<Long, ForecastLedgerVO> oneMap, List<ForecastLedgerVO> resDatas) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(ForecastDetailEntity::getPid, oneMap.keySet());
        List resList = this.forecastDetailService.list((Wrapper)lambda);
        List ListVOList = BeanMapper.mapList((Iterable)resList, ForecastLedgerVO.class);
        ArrayList<ForecastLedgerVO> listFather = new ArrayList<ForecastLedgerVO>();
        ArrayList<Object> listThirdStage = new ArrayList();
        HashMap<String, ForecastLedgerVO> map = new HashMap<String, ForecastLedgerVO>();
        Map<Long, ForecastLedgerVO> twoMap = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() == null).collect(Collectors.toMap(BaseVO::getId, forecastLedgerVO -> forecastLedgerVO));
        if (CollectionUtils.isNotEmpty((Collection)ListVOList)) {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy");
            for (ForecastLedgerVO forecastLedgerVO2 : ListVOList) {
                if (forecastLedgerVO2.getParentId() == null) {
                    forecastLedgerVO2.setParentId(forecastLedgerVO2.getPid());
                    forecastLedgerVO2.setOrgName(forecastLedgerVO2.getDetailOrgName());
                    forecastLedgerVO2.setOrgPersonName(forecastLedgerVO2.getDetailPersonName());
                    forecastLedgerVO2.setSaleForecastMny(forecastLedgerVO2.getSaleDetailMny());
                    forecastLedgerVO2.setInvoiceForecastMny(forecastLedgerVO2.getInvoiceDetailMny());
                    forecastLedgerVO2.setIncomeForecastMny(forecastLedgerVO2.getIncomeDetailMny());
                    forecastLedgerVO2.setForecastMonth(oneMap.get(forecastLedgerVO2.getPid()).getForecastMonth());
                    forecastLedgerVO2.setYear(sim.format(forecastLedgerVO2.getForecastMonth()));
                    listFather.add(forecastLedgerVO2);
                    continue;
                }
                String key = forecastLedgerVO2.getDetailPersonId() + "||" + forecastLedgerVO2.getParentId();
                if (map.containsKey(key)) {
                    ForecastLedgerVO vo = (ForecastLedgerVO)map.get(key);
                    BigDecimal SaleForecastMny = vo.getSaleForecastMny();
                    BigDecimal InvoiceForecastMny = vo.getInvoiceForecastMny();
                    BigDecimal IncomeForecastMny = vo.getIncomeForecastMny();
                    vo.setSaleForecastMny(ComputeUtil.safeAdd((BigDecimal)SaleForecastMny, (BigDecimal)forecastLedgerVO2.getSaleDetailMny()));
                    vo.setInvoiceForecastMny(ComputeUtil.safeAdd((BigDecimal)InvoiceForecastMny, (BigDecimal)forecastLedgerVO2.getInvoiceDetailMny()));
                    vo.setIncomeForecastMny(ComputeUtil.safeAdd((BigDecimal)IncomeForecastMny, (BigDecimal)forecastLedgerVO2.getIncomeDetailMny()));
                    continue;
                }
                forecastLedgerVO2.setOrgPersonName(forecastLedgerVO2.getDetailPersonName());
                forecastLedgerVO2.setDetailOrgId(twoMap.get(forecastLedgerVO2.getParentId()).getDetailOrgId());
                forecastLedgerVO2.setForecastMonth(oneMap.get(forecastLedgerVO2.getPid()).getForecastMonth());
                forecastLedgerVO2.setYear(sim.format(forecastLedgerVO2.getForecastMonth()));
                forecastLedgerVO2.setSaleForecastMny(forecastLedgerVO2.getSaleDetailMny());
                forecastLedgerVO2.setInvoiceForecastMny(forecastLedgerVO2.getInvoiceDetailMny());
                forecastLedgerVO2.setIncomeForecastMny(forecastLedgerVO2.getIncomeDetailMny());
                map.put(key, forecastLedgerVO2);
            }
            listThirdStage = new ArrayList(map.values());
        }
        ArrayList<ForecastLedgerVO> res = new ArrayList<ForecastLedgerVO>();
        LambdaQueryWrapper saleReportWrapper = new LambdaQueryWrapper();
        saleReportWrapper.isNull(SaleReportEntity::getSaleType);
        List saleReportEntityList = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
        HashMap reportEntityMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleReportEntityList)) {
            saleReportEntityList.forEach(e -> {
                String key = e.getYear() + "|" + e.getOrgId() + "|" + e.getEmployeeId();
                if (reportEntityMap.containsKey(key)) {
                    List saleReportEntities = (List)reportEntityMap.get(key);
                    saleReportEntities.add(e);
                    reportEntityMap.put(key, saleReportEntities);
                } else {
                    ArrayList<SaleReportEntity> saleReportEntities = new ArrayList<SaleReportEntity>();
                    saleReportEntities.add((SaleReportEntity)((Object)e));
                    reportEntityMap.put(key, saleReportEntities);
                }
            });
        }
        HashMap thirdMap = new HashMap();
        listThirdStage.forEach(e -> {
            String key = e.getYear() + "|" + e.getDetailOrgId() + "|" + e.getDetailPersonId();
            res.add(this.changeForecastLedgerVO((ForecastLedgerVO)e, (List)reportEntityMap.get(key)));
            if (thirdMap.containsKey(e.getParentId())) {
                List forecastLedgerVOList = (List)thirdMap.get(e.getParentId());
                forecastLedgerVOList.add(e);
                thirdMap.put(e.getParentId(), forecastLedgerVOList);
            } else {
                ArrayList<ForecastLedgerVO> forecastLedgerVOList = new ArrayList<ForecastLedgerVO>();
                forecastLedgerVOList.add((ForecastLedgerVO)e);
                thirdMap.put(e.getParentId(), forecastLedgerVOList);
            }
        });
        HashMap sunMap = new HashMap();
        listFather.forEach(e -> {
            List<ForecastLedgerVO> forecastLedgerVOList;
            if (thirdMap.containsKey(e.getId())) {
                List forecastLedgerVOS = (List)thirdMap.get(e.getId());
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                for (ForecastLedgerVO forecastLedgerVO : forecastLedgerVOS) {
                    if (forecastLedgerVO.getSaleCompletionMny() != null) {
                        CompletionMny = CompletionMny.add(forecastLedgerVO.getSaleCompletionMny());
                    }
                    if (forecastLedgerVO.getInvoiceCompletionMny() != null) {
                        invoiceCompletionMny = invoiceCompletionMny.add(forecastLedgerVO.getInvoiceCompletionMny());
                    }
                    if (forecastLedgerVO.getIncomeCompletionMny() == null) continue;
                    incomeCompletionMny = incomeCompletionMny.add(forecastLedgerVO.getIncomeCompletionMny());
                }
                this.setMny1((ForecastLedgerVO)e, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
            } else {
                String key = e.getYear() + "|" + e.getDetailOrgId() + "|" + e.getDetailPersonId();
                ForecastLedgerVO forecastLedgerVO = this.changeForecastLedgerVO((ForecastLedgerVO)e, (List)reportEntityMap.get(key));
            }
            res.add((ForecastLedgerVO)e);
            if (sunMap.containsKey(e.getParentId())) {
                forecastLedgerVOList = (List)sunMap.get(e.getParentId());
                forecastLedgerVOList.add((ForecastLedgerVO)e);
                sunMap.put(e.getParentId(), forecastLedgerVOList);
            } else {
                forecastLedgerVOList = new ArrayList<ForecastLedgerVO>();
                forecastLedgerVOList.add((ForecastLedgerVO)e);
                sunMap.put(e.getParentId(), forecastLedgerVOList);
            }
        });
        resDatas.forEach(e -> {
            if (sunMap.containsKey(e.getId())) {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                List forecastLedgerVOS = (List)sunMap.get(e.getId());
                for (ForecastLedgerVO forecastLedgerVO : forecastLedgerVOS) {
                    if (forecastLedgerVO.getSaleCompletionMny() != null) {
                        CompletionMny = CompletionMny.add(forecastLedgerVO.getSaleCompletionMny());
                    }
                    if (forecastLedgerVO.getInvoiceCompletionMny() != null) {
                        invoiceCompletionMny = invoiceCompletionMny.add(forecastLedgerVO.getInvoiceCompletionMny());
                    }
                    if (forecastLedgerVO.getIncomeCompletionMny() == null) continue;
                    incomeCompletionMny = incomeCompletionMny.add(forecastLedgerVO.getIncomeCompletionMny());
                }
                this.setMny1((ForecastLedgerVO)e, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
            }
            res.add((ForecastLedgerVO)e);
        });
        return res;
    }

    public ForecastLedgerVO changeForecastLedgerVO(ForecastLedgerVO child, List<SaleReportEntity> saleReportEntities) {
        String month;
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM");
        switch (month = sim.format(child.getForecastMonth()).substring(5, 7)) {
            case "01": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if (saleReportEntity.getKpFirstOneMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if (saleReportEntity.getSkFirstOneMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "02": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {
                            // empty if block
                        }
                        if (saleReportEntity.getSkFirstTwoMny() == null) continue;
                        invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "03": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());
                        }
                        if (saleReportEntity.getKpFirstThreeMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if (saleReportEntity.getSkFirstThreeMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "04": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if (saleReportEntity.getKpSecondFourMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if (saleReportEntity.getSkSecondFourMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "05": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());
                        }
                        if (saleReportEntity.getKpSecondFiveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if (saleReportEntity.getSkSecondFiveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "06": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if (saleReportEntity.getKpSecondSixMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if (saleReportEntity.getSkSecondSixMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "07": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if (saleReportEntity.getKpThirdSevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if (saleReportEntity.getSkThirdSevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "08": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if (saleReportEntity.getKpThirdEightMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if (saleReportEntity.getSkThirdEightMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "09": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if (saleReportEntity.getKpThirdNineMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if (saleReportEntity.getSkThirdNineMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "10": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if (saleReportEntity.getKpFourthTenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if (saleReportEntity.getSkFourthTenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "11": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if (saleReportEntity.getKpFourthElevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if (saleReportEntity.getSkFourthElevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "12": {
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if (saleReportEntity.getKpFourthTwelveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if (saleReportEntity.getSkFourthTwelveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                    }
                }
                this.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
        }
        return child;
    }

    public void setMny1(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        child.setSaleCompletionMny(CompletionMny);
        child.setInvoiceCompletionMny(invoiceCompletionMny);
        child.setIncomeCompletionMny(incomeCompletionMny);
        BigDecimal completionGap = ComputeUtil.safeSub((BigDecimal)child.getSaleCompletionMny(), (BigDecimal)child.getSaleForecastMny());
        BigDecimal invoiceCompletionGap = ComputeUtil.safeSub((BigDecimal)child.getInvoiceCompletionMny(), (BigDecimal)child.getInvoiceForecastMny());
        BigDecimal incomeCompletionGap = ComputeUtil.safeSub((BigDecimal)child.getIncomeCompletionMny(), (BigDecimal)child.getIncomeForecastMny());
        child.setSaleCompletionGap(completionGap);
        child.setInvoiceCompletionGap(invoiceCompletionGap);
        child.setIncomeCompletionGap(incomeCompletionGap);
    }
}

