/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.report.bean.StrategyPlanEntity;
import com.ejianc.business.jlincome.report.service.IStrategyPlanService;
import com.ejianc.business.jlincome.report.vo.StrategyPlanReportVO;
import com.ejianc.business.jlincome.report.vo.StrategyPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"strategyPlan"})
public class StrategyPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IStrategyPlanService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StrategyPlanVO> saveOrUpdate(@RequestBody StrategyPlanVO saveOrUpdateVO) {
        StrategyPlanEntity entity = (StrategyPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StrategyPlanEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        StrategyPlanVO vo = (StrategyPlanVO)BeanMapper.map((Object)((Object)entity), StrategyPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StrategyPlanVO> queryDetail(Long id) {
        StrategyPlanEntity entity = (StrategyPlanEntity)((Object)this.service.selectById(id));
        StrategyPlanVO vo = (StrategyPlanVO)BeanMapper.map((Object)((Object)entity), StrategyPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryListReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        List<StrategyPlanReportVO> detialList;
        QueryWrapper wrapper;
        Page page;
        List<StrategyPlanReportVO> resList;
        List fuzzyFields = param.getFuzzyFields();
        if (param.getParams().containsKey("reportMonth")) {
            Parameter reportMonth = (Parameter)param.getParams().get("reportMonth");
            reportMonth.setValue((Object)(reportMonth.getValue().toString() + "-01"));
        }
        if (CollectionUtils.isNotEmpty(resList = this.service.queryListAll((Page<StrategyPlanReportVO>)(page = new Page((long)param.getPageIndex(), (long)param.getPageSize())), wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param))) && CollectionUtils.isNotEmpty(detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList())))) {
            resList.addAll(detialList);
        }
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StrategyPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StrategyPlanVO strategyPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StrategyPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StrategyPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<StrategyPlanReportVO> detialList;
        QueryWrapper wrapper;
        Page page;
        List<StrategyPlanReportVO> resList;
        List fuzzyFields = param.getFuzzyFields();
        if (param.getParams().containsKey("reportMonth")) {
            Parameter reportMonth = (Parameter)param.getParams().get("reportMonth");
            reportMonth.setValue((Object)(reportMonth.getValue().toString() + "-01"));
        }
        if (CollectionUtils.isNotEmpty(resList = this.service.queryListAll((Page<StrategyPlanReportVO>)(page = new Page((long)param.getPageIndex(), (long)param.getPageSize())), wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param))) && CollectionUtils.isNotEmpty(detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList())))) {
            resList.addAll(detialList);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", TreeNodeBUtil.buildTree(resList));
        ExcelExport.getInstance().export("StrategyPlanReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStrategyPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StrategyPlanVO>> refStrategyPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StrategyPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

