package com.ejianc.busness.jlmiddledb.controller;

import com.ejianc.busness.jlmiddledb.bean.KeHuEntity;
import com.ejianc.busness.jlmiddledb.service.IKeHuService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.sql.Driver;
import java.util.List;

/**
 * 施工阶段档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("phaseArchive")
public class KeHuController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IKeHuService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KeHuEntity>> queryDetail(Long id) {
        QueryParam param = new QueryParam();
        List<KeHuEntity> list = service.queryPage(param,false).getRecords();
        return CommonResponse.success("查询详情数据成功！",list);
    }

}
