package com.ejianc.busness.jlmiddledb.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ejianc.framework.core.response.QueryParam;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 业务service的基类
 * 
 * @author guominga
 * @date 2020年2月16日
 */
public interface IMyBaseService<T> extends IService<T> {
	
	/**
	 * 查询实体对象的customField
	 * 
	 * @param entity 实体对象
	 */
	boolean setCustomField(T entity);

	/**
	 * 增加或修改对象
	 *
	 * @param entity 实体对象
	 * @param syncEs 是否同步es
	 */
	boolean saveOrUpdate(T entity, boolean syncEs);
	/**
	 * 增加或修改对象 不走es
	 *
	 * @param entity 实体对象
	 * @param syncEs 是否同步es
	 */
	boolean saveOrUpdateNoES(T entity);
	
	/**
	 * 批量增加或修改对象
	 * 
	 * @param entityList 实体对象list
	 * @param batchSize 一次批量增加或修改对象数量
	 * @param syncEs 是否同步es
	 */
	boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs);
	
	/**
	 * 根据主键ID查询对象
	 * 
	 * @param id 主键id
	 */
	T selectById(Serializable id);
	/**
	 * 根据主键ID查询对象
	 *
	 * @param id 主键id
	 */
	T selectById(Serializable id,Map<String,LinkedHashMap<String,String>> subOrderMap);

	/**
	 * 根据主键ID删除对象
	 *
	 * @param id 主键id
	 * @param syncEs 是否同步es
	 */
	boolean removeById(Serializable id, boolean syncEs);

	/**
	 * 根据map删除对象
	 * 
	 * @param columnMap 参数map
	 * @param syncEs 是否同步es
	 */
	boolean removeByMap(Map<String, Object> columnMap, boolean syncEs);
	
	/**
	 * 根据wrapper条件删除对象
	 * 
	 * @param wrapper 参数条件
	 * @param syncEs 是否同步es
	 */
	boolean remove(Wrapper<T> wrapper, boolean syncEs);

	/**
	 * 根据主键Idlist删除满足条件的对象
	 * 
	 * @param idList 参数条件
	 * @param syncEs 是否同步es
	 */
	boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs);
	
	/**
	 * 根据wrapper修改对象
	 * 
	 * @param entity 实体对象
	 * @param updateWrapper 条件
	 * @param syncEs 是否同步es
	 */
	boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs);
	
	/**
	 * 根据查询对象查询list
	 * 
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	List<T> queryList(QueryParam queryParam, boolean isEs);
	
	/**
	 * 查询分页对象
	 * 
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	IPage<T> queryPage(QueryParam queryParam, boolean isEs);

	/**
	 * 根据查询对象查询list
	 *
	 * @param queryParam 查询参数 默认不走es
	 * @return
	 */
	List<T> queryList(QueryParam queryParam);

	/**
	 * 查询分页对象
	 *
	 * @param queryParam 查询参数 默认不走es
	 * @return
	 */
	IPage<T> queryPage(QueryParam queryParam);

	/**
	 * 是否只能查看本人单据
	 *
	 * @param billTypeId 单据类型的id
	 *
	 * @return true 只能查看本人，false 查看全部
	 */
	Boolean viewSelf(String billTypeId);
}
