package com.ejianc.business.jlprogress.order.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.order.bean.ProductOutDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 订单及运单-产品出库单-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_order_product_out")
public class ProductOutEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 出库编码
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同code
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="customer_id")
    private Long customerId; // 客户ID
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="sale_id")
    private Long saleId; // 业务员ID
    @TableField(value="sale_code")
    private String saleCode; // 业务员code
    @TableField(value="sale_name")
    private String saleName; // 业务员
    @TableField(value="out_date")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date outDate; // 单据日期
    @TableField(value="store_id")
    private Long storeId; // 仓库ID
    @TableField(value="store_code")
    private String storeCode; // 仓库code
    @TableField(value="store_name")
    private String storeName; // 仓库
    @TableField(value="storeman")
    private String storeman; // 库管员
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="productOutDetailService",pidName = "outId")
    private List<ProductOutDetailEntity> productOutDetailList = new ArrayList<>(); // 订单及运单-产品出库单-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSaleId() {
        return saleId;
    }

    public void setSaleId(Long saleId) {
        this.saleId = saleId;
    }
    public String getSaleCode() {
        return saleCode;
    }

    public void setSaleCode(String saleCode) {
        this.saleCode = saleCode;
    }
    public String getSaleName() {
        return saleName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public String getStoreman() {
        return storeman;
    }

    public void setStoreman(String storeman) {
        this.storeman = storeman;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<ProductOutDetailEntity> getProductOutDetailList() {
        return productOutDetailList;
    }

    public void setProductOutDetailList(List<ProductOutDetailEntity> productOutDetailList) {
        this.productOutDetailList = productOutDetailList;
    }
}
