package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.bean.OutStoreDetailEntity;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.bean.PriceDetailEntity;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.service.IOutStoreDetailService;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;
import com.ejianc.business.jlprogress.order.service.IPriceDetailService;
import com.ejianc.business.jlprogress.order.service.IPriceService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.elasticsearch.common.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;

@Service("price")
public class PriceBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPriceService priceService;

	@Autowired
	private IPriceDetailService priceDetailService;
	@Autowired
	private IOutStoreService outStoreService;

	@Autowired
	private IOutStoreDetailService outStoreDetailService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 审批通过  更改出库单  的单价金额
		//获取金额主表
		PriceEntity price = priceService.getById(billId);
		//获取金额子表
		QueryParam param = new QueryParam();
		param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
		param.getParams().put("priceId",new Parameter(QueryParam.EQ,price.getId()));
		List<PriceDetailEntity> priceDetailEntities = priceDetailService.queryList(param);

		//获取金额仓库ids
		List<Long> storeIds = priceDetailEntities.stream().map(PriceDetailEntity::getStoreId).collect(Collectors.toList());
		//获取金额  材料ids--金额
		Map<Long, BigDecimal> map = new HashMap<>();
		for (PriceDetailEntity priceDetail: priceDetailEntities) {
			map.put(priceDetail.getMaterialId(),priceDetail.getMaterialPrice());
		}
		List<Long> materialIds = priceDetailEntities.stream().map(PriceDetailEntity::getMaterialId).collect(Collectors.toList());


		//根据金额主表查询出相应的  出库单据
		QueryWrapper<OutStoreEntity> outStoreParam = new QueryWrapper<>();
		outStoreParam.eq("store_org_id",price.getOrgId());
		outStoreParam.in("store_id",storeIds);
		//Calendar calendar = Calendar.getInstance();
		//calendar.setTime(price.getMonth());
		//int year = calendar.get(Calendar.YEAR);
		//int month = calendar.get(Calendar.MONTH);
		//calendar.set(year,month+1,1);
		//calendar.add(Calendar.DATE,-1);
		logger.info("日期"+price.getMonth());
		Instant instant=price.getMonth().toInstant();
		ZoneId zoneId = ZoneId.systemDefault();
		LocalDate date = instant.atZone(zoneId).toLocalDate();
		outStoreParam.ge("store_date",date.with(TemporalAdjusters.firstDayOfMonth()));
		outStoreParam.le("store_date",date.plusMonths(1).with(TemporalAdjusters.firstDayOfMonth()));
		List<OutStoreEntity> outStoreEntities = outStoreService.list(outStoreParam);
		logger.info("相关的出库单据:"+outStoreEntities.size());
		//遍历主表  更改信息
		for (OutStoreEntity outStore: outStoreEntities) {
			//根据 金额子表 查询是否存在出库子表
			QueryWrapper<OutStoreDetailEntity> outStoreDetailWrapper = new QueryWrapper<>();
			outStoreDetailWrapper.in("material_id",materialIds);
			outStoreDetailWrapper.eq("out_store_id",outStore.getId());
			List<OutStoreDetailEntity> outStoreDetailEntities = outStoreDetailService.list(outStoreDetailWrapper);
			if (ObjectUtils.isEmpty(outStoreDetailEntities)){
				logger.info("不存在出库子表");

			}else{
				//更新子表数据
				for (OutStoreDetailEntity outStoreDetail:outStoreDetailEntities){
					if (outStoreDetail.getDetailStorePrice().compareTo(map.get(outStoreDetail.getMaterialId()))!=0){
						outStoreDetail.setDetailStorePrice(map.get(outStoreDetail.getMaterialId()));
						outStoreDetail.setDetailStoreMny(outStoreDetail.getDetailStorePrice().multiply(outStoreDetail.getMaterialNum()));
						outStoreDetailService.updateById(outStoreDetail);
					}
				}
				//更新主表数据
					//子表汇总
				BigDecimal storeMny = outStoreDetailService.getStoreMny(outStore.getId());
				logger.info("更新后的金额汇总"+storeMny);
				//更新主表
				outStore.setStoreMny(storeMny);
				outStoreService.updateById(outStore);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
