package com.ejianc.business.jlprogress.quality.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 质量检测-成品检测记录
 *
 * @author generator
 *
 */
 @TableName("ejc_quality_finished_check")
public class FinishedCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据提交状态：0-暂存,1-提交
    @TableField(value="supply_id")
    private Long supplyId; // 供货单ID
    @TableField(value="supply_code")
    private String supplyCode; // 供货单编码
    @TableField(value="wbs_id")
    private Long wbsId; // 产品ID
    @TableField(value="wbs_name")
    private String wbsName; // 产品名称
    @TableField(value="total_num")
    private BigDecimal totalNum; // 检验数
    @TableField(value="qualified_num")
    private BigDecimal qualifiedNum; // 合格数
    @TableField(value="sampling_num")
    private BigDecimal samplingNum; // 抽检数
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检测日期
    @TableField(value="check_user_id")
    private Long checkUserId; // 检测员ID
    @TableField(value="check_user_name")
    private String checkUserName; // 检测员名称
    @TableField(value="qualified_scale")
    private BigDecimal qualifiedScale; // 合格率
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="use_state")
    private Integer useState; // 引用标识0-未引用1-已引用

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }
    public BigDecimal getQualifiedNum() {
        return qualifiedNum;
    }

    public void setQualifiedNum(BigDecimal qualifiedNum) {
        this.qualifiedNum = qualifiedNum;
    }
    public BigDecimal getSamplingNum() {
        return samplingNum;
    }

    public void setSamplingNum(BigDecimal samplingNum) {
        this.samplingNum = samplingNum;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Long getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
    }
    public String getCheckUserName() {
        return checkUserName;
    }

    public void setCheckUserName(String checkUserName) {
        this.checkUserName = checkUserName;
    }
    public BigDecimal getQualifiedScale() {
        return qualifiedScale;
    }

    public void setQualifiedScale(BigDecimal qualifiedScale) {
        this.qualifiedScale = qualifiedScale;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getUseState() {
        return useState;
    }

    public void setUseState(Integer useState) {
        this.useState = useState;
    }
}
