package com.ejianc.business.jlprogress.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.vo.DetectReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.DetectReportMapper;
import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;

import java.util.List;

/**
 * 质量检测-检测报告
 *
 * @author generator
 */
@Service("detectReportService")
public class DetectReportServiceImpl extends BaseServiceImpl<DetectReportMapper, DetectReportEntity> implements IDetectReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "JCBG";//此处需要根据实际修改

    @Override
    public DetectReportVO saveOrUpdate(DetectReportVO saveOrUpdateVO) {
        DetectReportEntity entity = BeanMapper.map(saveOrUpdateVO, DetectReportEntity.class);
        if(StringUtils.isNotBlank(entity.getBillCode())){
            checkCode(entity);
        }else{
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        DetectReportVO vo = BeanMapper.map(entity, DetectReportVO.class);
        return vo;
    }
    public void checkCode(DetectReportEntity entity) {
        QueryWrapper<DetectReportEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("bill_code", entity.getBillCode());
        queryWrapper.eq("dr", 0);
        if(entity.getId() != null ){
            queryWrapper.ne("id", entity.getId());
        }
        List<DetectReportEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("检查报告编号重复，请重新输入！");

        }
    }
}
