/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.vo.ProductOutDetailVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"productOut"})
public class ProductOutController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProductOutService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductOutVO> saveOrUpdate(@RequestBody ProductOutVO saveOrUpdateVO) {
        ProductOutEntity entity = (ProductOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProductOutEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ProductOutVO vo = (ProductOutVO)BeanMapper.map((Object)((Object)entity), ProductOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductOutVO> queryDetail(Long id) {
        ProductOutEntity entity = (ProductOutEntity)((Object)this.service.selectById(id));
        ProductOutVO vo = (ProductOutVO)BeanMapper.map((Object)((Object)entity), ProductOutVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProductOutVO productOutVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductOutVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeman");
        fuzzyFields.add("outDate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeman");
        fuzzyFields.add("outDate");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List resDatas = BeanMapper.mapList((Iterable)list, ProductOutVO.class);
        for (ProductOutVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0: {
                    resData.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    resData.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: 
                case 5: {
                    resData.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    resData.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    resData.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("ProductOut-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductOutData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductOutVO>> refProductOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            Integer contractId = _con.getInteger("contractId");
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/productOutDataRef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProductOutVO> productOutDataRef(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List resList;
        JSONObject _con;
        List dataVoList = null;
        ArrayList<Integer> billList = new ArrayList<Integer>();
        billList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        Long contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            contractId = Long.valueOf(String.valueOf(_con.get((Object)"contractId")));
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        if (null != contractId) {
            lambda.eq(ProductOutEntity::getContractId, contractId);
        }
        lambda.in(ProductOutEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        lambda.in(ProductOutEntity::getBillState, billList);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            lambda.like(ProductOutEntity::getBillCode, (Object)searchText);
        }
        if (CollectionUtils.isNotEmpty((Collection)(resList = this.service.list((Wrapper)lambda)))) {
            dataVoList = BeanMapper.mapList((Iterable)resList, ProductOutVO.class);
            dataVoList.forEach(e -> {
                e.setCode(e.getBillCode());
                e.setName(e.getBillCode());
            });
        }
        return dataVoList;
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ProductOutDetail-import.xlsx", (String)"\u4ea7\u54c1\u51fa\u5e93\u5355\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ProductOutDetailVO> successList = new ArrayList<ProductOutDetailVO>();
        ArrayList<ProductOutDetailVO> errorList = new ArrayList<ProductOutDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ProductOutDetailVO detailVO = new ProductOutDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = (String)datas.get(0);
                try {
                    if (ObjectUtils.isEmpty((Object)map.get(materialCode))) {
                        throw new Exception("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    }
                    detailVO.setMaterialCode(materialCode);
                    detailVO.setMaterialId(((MaterialVO)map.get(materialCode)).getId());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setMaterialName(((MaterialVO)map.get(materialCode)).getName());
                detailVO.setMaterialId(((MaterialVO)map.get(materialCode)).getId());
                detailVO.setMaterialTypeId(((MaterialVO)map.get(materialCode)).getCategoryId());
                detailVO.setMaterialTypeCode(((MaterialVO)map.get(materialCode)).getCategoryCode());
                detailVO.setMaterialTypeName(((MaterialVO)map.get(materialCode)).getCategoryName());
                detailVO.setUnit(((MaterialVO)map.get(materialCode)).getUnitName());
                detailVO.setSpec(((MaterialVO)map.get(materialCode)).getSpec());
                detailVO.setModel(((MaterialVO)map.get(materialCode)).getModel());
                String assistUnit = (String)datas.get(4);
                detailVO.setAssistUnit(assistUnit);
                try {
                    String materialNum = (String)datas.get(5);
                    detailVO.setMaterialNum(StringUtils.isNotBlank((CharSequence)materialNum) ? new BigDecimal(materialNum) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5b9e\u53d1\u4e3b\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String materialAssistNum = (String)datas.get(6);
                    detailVO.setMaterialAssistNum(StringUtils.isNotBlank((CharSequence)materialAssistNum) ? new BigDecimal(materialAssistNum) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5b9e\u53d1\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

