/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.bean.OutStoreDetailEntity;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.bean.PriceDetailEntity;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.service.IOutStoreDetailService;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;
import com.ejianc.business.jlprogress.order.service.IPriceDetailService;
import com.ejianc.business.jlprogress.order.service.IPriceService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="price")
public class PriceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceService priceService;
    @Autowired
    private IPriceDetailService priceDetailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IOutStoreDetailService outStoreDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PriceEntity price = (PriceEntity)((Object)this.priceService.getById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("priceId", new Parameter("eq", (Object)price.getId()));
        List priceDetailEntities = this.priceDetailService.queryList(param);
        List storeIds = priceDetailEntities.stream().map(PriceDetailEntity::getStoreId).collect(Collectors.toList());
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (PriceDetailEntity priceDetail : priceDetailEntities) {
            map.put(priceDetail.getMaterialId(), priceDetail.getMaterialPrice());
        }
        List materialIds = priceDetailEntities.stream().map(PriceDetailEntity::getMaterialId).collect(Collectors.toList());
        QueryWrapper outStoreParam = new QueryWrapper();
        outStoreParam.eq((Object)"store_org_id", (Object)price.getOrgId());
        outStoreParam.in((Object)"store_id", storeIds);
        outStoreParam.in((Object)"dr", new Object[]{0});
        this.logger.info("\u65e5\u671f" + price.getMonth());
        Instant instant = price.getMonth().toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate date = instant.atZone(zoneId).toLocalDate();
        outStoreParam.ge((Object)"store_date", (Object)date.with(TemporalAdjusters.firstDayOfMonth()));
        outStoreParam.le((Object)"store_date", (Object)date.plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()));
        List outStoreEntities = this.outStoreService.list((Wrapper)outStoreParam);
        this.logger.info("\u76f8\u5173\u7684\u51fa\u5e93\u5355\u636e:" + outStoreEntities.size());
        for (OutStoreEntity outStore : outStoreEntities) {
            QueryWrapper outStoreDetailWrapper = new QueryWrapper();
            outStoreDetailWrapper.in((Object)"material_id", materialIds);
            outStoreDetailWrapper.eq((Object)"out_store_id", (Object)outStore.getId());
            List outStoreDetailEntities = this.outStoreDetailService.list((Wrapper)outStoreDetailWrapper);
            if (ObjectUtils.isEmpty((Object)outStoreDetailEntities)) {
                this.logger.info("\u4e0d\u5b58\u5728\u51fa\u5e93\u5b50\u8868");
                continue;
            }
            for (OutStoreDetailEntity outStoreDetail : outStoreDetailEntities) {
                if (outStoreDetail.getDetailStorePrice().compareTo((BigDecimal)map.get(outStoreDetail.getMaterialId())) == 0) continue;
                outStoreDetail.setDetailStorePrice((BigDecimal)map.get(outStoreDetail.getMaterialId()));
                outStoreDetail.setDetailStoreMny(outStoreDetail.getDetailStorePrice().multiply(outStoreDetail.getMaterialNum()));
                this.outStoreDetailService.updateById((Object)outStoreDetail);
            }
            BigDecimal storeMny = this.outStoreDetailService.getStoreMny(outStore.getId());
            this.logger.info("\u66f4\u65b0\u540e\u7684\u91d1\u989d\u6c47\u603b" + storeMny);
            outStore.setStoreMny(storeMny);
            this.outStoreService.updateById((Object)outStore);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

