/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.bean.DisposeEntity;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.service.IDisposeService;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.DisposeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dispose"})
public class DisposeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROGRESS_DISPOSE";
    @Autowired
    private IDisposeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProcessCheckService processCheckService;
    @Autowired
    private IFinishedCheckService finishedCheckService;
    @Autowired
    private IDetectReportService detectReportService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeVO disposeVO = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)disposeVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(id));
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            DetectReportEntity detectReportEntity;
            FinishedCheckEntity finishedCheckEntity;
            ProcessCheckEntity processCheckEntity;
            DisposeEntity disposeEntity = (DisposeEntity)((Object)this.service.selectById(id));
            if (disposeEntity.getType() == 1 && (processCheckEntity = (ProcessCheckEntity)((Object)this.processCheckService.selectById(disposeEntity.getCheckId()))) != null) {
                processCheckEntity.setUseState(0);
                this.processCheckService.updateById((Object)processCheckEntity);
            }
            if (disposeEntity.getType() == 2 && (finishedCheckEntity = (FinishedCheckEntity)((Object)this.finishedCheckService.selectById(disposeEntity.getCheckId()))) != null) {
                finishedCheckEntity.setUseState(0);
                this.finishedCheckService.updateById((Object)finishedCheckEntity);
            }
            if (disposeEntity.getType() != 3 || (detectReportEntity = (DetectReportEntity)((Object)this.detectReportService.selectById(disposeEntity.getCheckId()))) == null) continue;
            detectReportEntity.setReferenceFlag(0);
            this.detectReportService.updateById((Object)detectReportEntity);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DisposeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List disposeVOS = new ArrayList();
        disposeVOS = BeanMapper.mapList((Iterable)list, DisposeVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DisposeVO disposeVO : disposeVOS) {
                if (disposeVO.getType() == 1) {
                    disposeVO.setTypeName("\u5de5\u5e8f\u68c0\u6d4b");
                }
                if (disposeVO.getType() == 2) {
                    disposeVO.setTypeName("\u6210\u54c1\u68c0\u6d4b");
                }
                if (disposeVO.getType() == 3) {
                    disposeVO.setTypeName("\u539f\u6750\u68c0\u6d4b");
                }
                disposeVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)disposeVO.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", disposeVOS);
        ExcelExport.getInstance().export("Dispose-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDisposeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DisposeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

