/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.MatCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.service.IMatCheckService;
import com.ejianc.business.jlprogress.quality.service.ISupplyService;
import com.ejianc.business.jlprogress.quality.vo.MatCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matCheck"})
public class MatCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MAT_CHECK";
    @Autowired
    private IMatCheckService service;
    @Autowired
    private ISupplyService supplyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatCheckVO> saveOrUpdate(@RequestBody MatCheckVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper;
        saveOrUpdateVO.setOrgId(InvocationInfoProxy.getOrgId());
        if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            queryWrapper.eq(MatCheckEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
            if (this.service.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u7f16\u7801\u5df2\u5b58\u5728!");
            }
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(MatCheckEntity::getSupplyId, (Object)saveOrUpdateVO.getSupplyId());
        if (this.service.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u8be5\u4f9b\u8d27\u5355\u5df2\u88ab\u5f15\u7528\u8fc7!");
        }
        MatCheckEntity entity = (MatCheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatCheckEntity.class));
        if (StringUtils.isBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MatCheckVO vo = (MatCheckVO)BeanMapper.map((Object)((Object)entity), MatCheckVO.class);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getSupplyId());
        updateWrapper.set(SupplyEntity::getReferenceFlag, (Object)1);
        this.supplyService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatCheckVO> queryDetail(Long id) {
        MatCheckEntity entity = (MatCheckEntity)((Object)this.service.selectById(id));
        MatCheckVO vo = (MatCheckVO)BeanMapper.map((Object)((Object)entity), MatCheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatCheckVO matCheckVO : vos) {
            }
        }
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(collect, true);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, collect);
        updateWrapper.set(SupplyEntity::getReferenceFlag, (Object)0);
        this.supplyService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkUserName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkUserName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", list);
        ExcelExport.getInstance().export("MatCheck-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatCheckVO>> refMatCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

