/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.bean.DisposeEntity;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.mapper.DisposeMapper;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.service.IDisposeService;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.DisposeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="disposeService")
public class DisposeServiceImpl
extends BaseServiceImpl<DisposeMapper, DisposeEntity>
implements IDisposeService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROGRESS_DISPOSE";
    @Autowired
    private IProcessCheckService processCheckService;
    @Autowired
    private IFinishedCheckService finishedCheckService;
    @Autowired
    private IDetectReportService detectReportService;

    @Override
    public DisposeVO saveOrUpdate(DisposeVO saveOrUpdateVO) {
        DetectReportEntity detectReportEntity;
        FinishedCheckEntity finishedCheckEntity;
        ProcessCheckEntity processCheckEntity;
        DisposeEntity entity = (DisposeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DisposeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() != null) {
            DetectReportEntity detectReportEntity2;
            FinishedCheckEntity finishedCheckEntity2;
            ProcessCheckEntity processCheckEntity2;
            DisposeEntity disposeEntity = (DisposeEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (disposeEntity.getType() == 1 && (processCheckEntity2 = (ProcessCheckEntity)((Object)this.processCheckService.selectById(disposeEntity.getCheckId()))) != null) {
                processCheckEntity2.setUseState(0);
                this.processCheckService.updateById((Object)processCheckEntity2);
            }
            if (disposeEntity.getType() == 2 && (finishedCheckEntity2 = (FinishedCheckEntity)((Object)this.finishedCheckService.selectById(disposeEntity.getCheckId()))) != null) {
                finishedCheckEntity2.setUseState(0);
                this.finishedCheckService.updateById((Object)finishedCheckEntity2);
            }
            if (disposeEntity.getType() == 3 && (detectReportEntity2 = (DetectReportEntity)((Object)this.detectReportService.selectById(disposeEntity.getCheckId()))) != null) {
                detectReportEntity2.setReferenceFlag(0);
                this.detectReportService.updateById((Object)detectReportEntity2);
            }
        }
        if (entity.getType() == 1 && (processCheckEntity = (ProcessCheckEntity)((Object)this.processCheckService.selectById(entity.getCheckId()))) != null) {
            processCheckEntity.setUseState(1);
            this.processCheckService.updateById((Object)processCheckEntity);
        }
        if (entity.getType() == 2 && (finishedCheckEntity = (FinishedCheckEntity)((Object)this.finishedCheckService.selectById(entity.getCheckId()))) != null) {
            finishedCheckEntity.setUseState(1);
            this.finishedCheckService.updateById((Object)finishedCheckEntity);
        }
        if (entity.getType() == 3 && (detectReportEntity = (DetectReportEntity)((Object)this.detectReportService.selectById(entity.getCheckId()))) != null) {
            detectReportEntity.setReferenceFlag(1);
            this.detectReportService.updateById((Object)detectReportEntity);
        }
        super.saveOrUpdate((Object)entity, false);
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return vo;
    }
}

