package com.ejianc.business.jlprogress.order.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 订单及运单-材料价格-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_order_price")
public class PriceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 部门名称
    @TableField(value="month")
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date month; // 月份
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    @TableField(exist=false)
    @SubEntity(serviceName="priceDetailService",pidName = "priceId")
    private List<PriceDetailEntity> priceDetailList = new ArrayList<>(); // 材料价格表子表

    public List<PriceDetailEntity> getPriceDetailList() {
        return priceDetailList;
    }

    public void setPriceDetailList(List<PriceDetailEntity> priceDetailList) {
        this.priceDetailList = priceDetailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
