package com.ejianc.business.jlprogress.quality.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 物资供货单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_supply")
public class SupplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 供货单号
    @TableField(value="bill_state")
    private Integer billState; // 单据提交状态：0-暂存,1-提交
    @TableField(value="unit_id")
    private Long unitId; // 供货单位
    @TableField(value="unit_name")
    private String unitName; // 供货单位名称
    @TableField(value="purchase_id")
    private Long purchaseId; // 采购员
    @TableField(value="purchase_name")
    private String purchaseName; // 采购员名称
    @TableField(value="supply_date")
    private Date supplyDate; // 供货日期
    @TableField(value="use_memo")
    private String useMemo; // 用途
    @TableField(value="production_memo")
    private String productionMemo; // 生产厂商
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="reference_flag")
    private Integer referenceFlag; // 是否被引用 0-未引用,1-已引用
    
    @TableField(exist=false)
    @SubEntity(serviceName="supplyDetailService",pidName="supplyId")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplyDetailEntity> detailList = new ArrayList<>(); // 物资供货单详情

    public Integer getReferenceFlag() {
        return referenceFlag;
    }

    public void setReferenceFlag(Integer referenceFlag) {
        this.referenceFlag = referenceFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public Date getSupplyDate() {
        return supplyDate;
    }

    public void setSupplyDate(Date supplyDate) {
        this.supplyDate = supplyDate;
    }
    public String getUseMemo() {
        return useMemo;
    }

    public void setUseMemo(String useMemo) {
        this.useMemo = useMemo;
    }
    public String getProductionMemo() {
        return productionMemo;
    }

    public void setProductionMemo(String productionMemo) {
        this.productionMemo = productionMemo;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<SupplyDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SupplyDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
