package com.ejianc.business.jlprogress.quality.controller;

import java.io.Serializable;

import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.DisposeEntity;
import com.ejianc.business.jlprogress.quality.service.IDisposeService;
import com.ejianc.business.jlprogress.quality.vo.DisposeVO;

/**
 * 质量检测-不合计品处置单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dispose")
public class DisposeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROGRESS_DISPOSE";//此处需要根据实际修改

    @Autowired
    private IDisposeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProcessCheckService processCheckService;

    @Autowired
    private IFinishedCheckService finishedCheckService;

    @Autowired
    private IDetectReportService detectReportService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeVO disposeVO = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",disposeVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
    	DisposeEntity entity = service.selectById(id);
    	DisposeVO vo = BeanMapper.map(entity, DisposeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {

        //更新引用状态
        //退回之前的引用状态
        List<Long> ids = vos.stream().map(DisposeVO::getId).collect(Collectors.toList());
        for (Long id : ids){
            DisposeEntity disposeEntity = service.selectById(id);
            if (disposeEntity.getType() == 1){
                ProcessCheckEntity processCheckEntity = processCheckService.selectById(disposeEntity.getCheckId());
                if (processCheckEntity != null){
                    processCheckEntity.setUseState(0);
                    processCheckService.updateById(processCheckEntity);
                }

            }
            if (disposeEntity.getType() == 2){
                FinishedCheckEntity finishedCheckEntity = finishedCheckService.selectById(disposeEntity.getCheckId());
                if (finishedCheckEntity != null){
                    finishedCheckEntity.setUseState(0);
                    finishedCheckService.updateById(finishedCheckEntity);
                }

            }
            if (disposeEntity.getType() == 3){
                DetectReportEntity detectReportEntity = detectReportService.selectById(disposeEntity.getCheckId());
                if (detectReportEntity != null){
                    detectReportEntity.setReferenceFlag(0);
                    detectReportService.updateById(detectReportEntity);
                }

            }
        }

        service.removeByIds(vos.stream().map(DisposeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DisposeEntity> page = service.queryPage(param,false);
        IPage<DisposeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisposeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DisposeEntity> list = service.queryList(param);
        List<DisposeVO> disposeVOS = new ArrayList<>();
        disposeVOS = BeanMapper.mapList(list, DisposeVO.class);
        if (CollectionUtils.isNotEmpty(list)){

            for (DisposeVO disposeVO : disposeVOS){
                if (disposeVO.getType() == 1){
                    disposeVO.setTypeName("工序检测");
                }
                if (disposeVO.getType() == 2){
                    disposeVO.setTypeName("成品检测");
                }
                if (disposeVO.getType() == 3){
                    disposeVO.setTypeName("原材检测");
                }
                disposeVO.setBillStateName(BillStateEnum.getEnumByStateCode(disposeVO.getBillState()).getDescription());
            }
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", disposeVOS);
        ExcelExport.getInstance().export("Dispose-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDisposeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DisposeEntity> page = service.queryPage(param,false);
        IPage<DisposeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisposeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
