package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.EntrustDetectEntity;
import com.ejianc.business.jlprogress.quality.service.IEntrustDetectService;
import com.ejianc.business.jlprogress.quality.vo.DetectReportVO;
import com.ejianc.business.jlprogress.quality.vo.EntrustDetectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 质量检测-检测委托书
 *
 * @author generator
 */
@Controller
@RequestMapping("entrustDetect")
public class EntrustDetectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "NJCWTS";//此处需要根据实际修改


    @Autowired
    private IEntrustDetectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EntrustDetectVO> saveOrUpdate(@RequestBody EntrustDetectVO saveOrUpdateVO) {
        EntrustDetectVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EntrustDetectVO> queryDetail(Long id) {
        EntrustDetectEntity entity = service.selectById(id);
        EntrustDetectVO vo = BeanMapper.map(entity, EntrustDetectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EntrustDetectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EntrustDetectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EntrustDetectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EntrustDetectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("departName");
        fuzzyFields.add("sampleName");
        fuzzyFields.add("supplyName");
        fuzzyFields.add("detectMode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if ("1".equals(param.getParams().get("queryCoverage").getValue())) {
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache = sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                } else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        } else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<EntrustDetectEntity> page = service.queryPage(param, false);
        IPage<EntrustDetectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EntrustDetectVO> entrustDetectVOS = BeanMapper.mapList(page.getRecords(), EntrustDetectVO.class);
        entrustDetectVOS.stream().forEach(entrustDetectVO -> {
          if (entrustDetectVO.getDetectionType()==0){
              entrustDetectVO.setDetectionTypeStr("原材检测");
          }else if(entrustDetectVO.getDetectionType()==1){
              entrustDetectVO.setDetectionTypeStr("产品检测");

          }else if (entrustDetectVO.getDetectionType()==2){
              entrustDetectVO.setDetectionTypeStr("工序检测");
          }
        });
        pageData.setRecords(entrustDetectVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<EntrustDetectVO> records = new ArrayList<>();
        CommonResponse<IPage<EntrustDetectVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()){
            records = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        records.stream().forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("EntrustDetect-export.xlsx", beans, response);
    }
    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEntrustDetectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EntrustDetectVO>> refEntrustDetectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("departName");
        fuzzyFields.add("sampleName");
        fuzzyFields.add("supplyName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("entrustType")) {
                param.getParams().put("entrustType", new Parameter(QueryParam.EQ, _con.getString("entrustType")));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EntrustDetectEntity> page = service.queryPage(param, false);
        IPage<EntrustDetectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EntrustDetectVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
