/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;
import com.ejianc.business.jlprogress.order.service.IPriceDetailService;
import com.ejianc.business.jlprogress.order.service.IPriceService;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.order.vo.OutStoreVO;
import com.ejianc.business.jlprogress.order.vo.PriceDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"outStore"})
public class OutStoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IPriceService priceService;
    @Autowired
    private IPriceDetailService priceDetailService;
    private static final String BILL_CODE = "OUT_STORE";
    @Autowired
    private IOutStoreService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO saveOrUpdateVO) {
        List list;
        OutStoreEntity entity = (OutStoreEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutStoreEntity.class));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OutStoreEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        if (entity.getId() != null) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)lambdaQueryWrapper)))) {
            throw new BusinessException("\u5f53\u524d\u7f16\u7801\u5df2\u7ecf\u4f7f\u7528\uff01");
        }
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        this.service.saveOrUpdate((Object)entity, false);
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(id));
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutStoreVO outStoreVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeOrgName");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeEmployeeName");
        fuzzyFields.add("store_date");
        fuzzyFields.add("storeMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeOrgName");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeEmployeeName");
        fuzzyFields.add("store_date");
        fuzzyFields.add("storeMny");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        for (OutStoreEntity outStore : list) {
            switch (outStore.getBillState()) {
                case 0: {
                    outStore.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    outStore.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    outStore.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    outStore.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    outStore.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    outStore.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 6: {
                    outStore.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutStoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"OutStoreDetail-import.xlsx", (String)"\u6750\u6599\u51fa\u5e93-\u7269\u6599\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OutStoreDetailVO> successList = new ArrayList<OutStoreDetailVO>();
        ArrayList<OutStoreDetailVO> errorList = new ArrayList<OutStoreDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            ArrayList<Long> materialIdList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            materialIdList = ((List)materialRes.getData()).stream().map(MaterialVO::getId).collect(Collectors.toList());
            Long storeOrgId = Long.valueOf(request.getParameter("storeOrgId"));
            Long storeId = Long.valueOf(request.getParameter("storeId"));
            this.logger.info("storeOrgId: {} ,storeId: {}, storeData: {}", new Object[]{storeOrgId, storeId, request.getParameter("storeDate")});
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            Date storeData = ft.parse(request.getParameter("storeDate"));
            Map<Object, Object> priceMap = new HashMap();
            CommonResponse<List<PriceDetailVO>> listCommonResponse = this.queryPrice(materialIdList, storeOrgId, storeId, storeData);
            if (!listCommonResponse.isSuccess()) {
                return CommonResponse.error((String)listCommonResponse.getMsg());
            }
            if (ObjectUtils.isNotEmpty((Object)listCommonResponse.getData())) {
                priceMap = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(p -> p.getMaterialId(), Function.identity()));
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                OutStoreDetailVO detailVO = new OutStoreDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                try {
                    String materialCode = (String)datas.get(0);
                    detailVO.setMaterialCode(materialCode);
                    if (ObjectUtils.isEmpty((Object)map.get(materialCode))) {
                        throw new Exception("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    }
                    detailVO.setMaterialId(((MaterialVO)map.get(materialCode)).getId());
                    detailVO.setMaterialName(((MaterialVO)map.get(materialCode)).getName());
                    detailVO.setSpec(((MaterialVO)map.get(materialCode)).getSpec());
                    detailVO.setModel(((MaterialVO)map.get(materialCode)).getModel());
                    detailVO.setUnit(((MaterialVO)map.get(materialCode)).getUnitName());
                    detailVO.setMaterialTypeId(((MaterialVO)map.get(materialCode)).getCategoryId());
                    detailVO.setMaterialTypeCode(((MaterialVO)map.get(materialCode)).getCategoryCode());
                    detailVO.setMaterialTypeName(((MaterialVO)map.get(materialCode)).getCategoryName());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                String assistUnit = (String)datas.get(4);
                detailVO.setAssistUnit(assistUnit);
                try {
                    String materialNum = (String)datas.get(5);
                    detailVO.setMaterialNum(StringUtils.isNotBlank((CharSequence)materialNum) ? new BigDecimal(materialNum) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5b9e\u53d1\u4e3b\u6570\u91cf\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String materialAssistNum = (String)datas.get(6);
                    detailVO.setMaterialAssistNum(StringUtils.isNotBlank((CharSequence)materialAssistNum) ? new BigDecimal(materialAssistNum) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5b9e\u53d1\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (ObjectUtils.isNotEmpty((Object)priceMap.get(detailVO.getMaterialId()))) {
                    detailVO.setDetailStorePrice(((PriceDetailVO)priceMap.get(detailVO.getMaterialId())).getMaterialPrice());
                }
                if (ObjectUtils.isNotEmpty((Object)detailVO.getDetailStorePrice()) && ObjectUtils.isNotEmpty((Object)detailVO.getMaterialNum())) {
                    detailVO.setDetailStoreMny(((PriceDetailVO)priceMap.get(detailVO.getMaterialId())).getMaterialPrice().multiply(detailVO.getMaterialNum()));
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/queryPrice"})
    @ResponseBody
    public CommonResponse<List<PriceDetailVO>> queryPrice(@RequestParam List<Long> materialIds, Long storeOrgId, Long storeId, Date storeDate) {
        if (storeOrgId != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("orgId", new Parameter("eq", (Object)storeOrgId));
            Instant instant = storeDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate date = instant.atZone(zoneId).toLocalDate();
            this.logger.info("\u65e5\u671f" + date.with(TemporalAdjusters.firstDayOfMonth()));
            param.getParams().put("month", new Parameter("eq", (Object)date.with(TemporalAdjusters.firstDayOfMonth())));
            ArrayList<Integer> state = new ArrayList<Integer>();
            state.add(1);
            state.add(3);
            param.getParams().put("billState", new Parameter("in", state));
            param.getParams().put("dr", new Parameter("eq", (Object)0));
            List priceEntities = this.priceService.queryList(param);
            if (ObjectUtils.isEmpty((Object)priceEntities)) {
                param.getParams().put("month", new Parameter("eq", (Object)date.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth())));
                priceEntities = this.priceService.queryList(param);
                if (ObjectUtils.isEmpty((Object)priceEntities)) {
                    return CommonResponse.success((String)"\u6ca1\u6709\u4ef7\u683c");
                }
            }
            List ids = priceEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam param1 = new QueryParam();
            param1.getParams().put("priceId", new Parameter("in", ids));
            param1.getParams().put("storeId", new Parameter("eq", (Object)storeId));
            param1.getParams().put("materialId", new Parameter("in", materialIds));
            List priceDetailEntities = this.priceDetailService.queryList(param1);
            if (ObjectUtils.isEmpty((Object)priceDetailEntities)) {
                return CommonResponse.success((String)"\u6ca1\u6709\u4ef7\u683c");
            }
            List entity = BeanMapper.mapList((Iterable)priceDetailEntities, PriceDetailVO.class);
            return CommonResponse.success((Object)entity);
        }
        return null;
    }
}

