/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.SalesDetailVO;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"sales"})
public class SalesController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private ISalesService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalesVO> saveOrUpdate(@RequestBody SalesVO saveOrUpdateVO) {
        List list;
        SalesEntity entity = (SalesEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalesEntity.class));
        String billCode = entity.getBillCode();
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"bill_code", (Object)billCode);
        if (entity.getId() != null) {
            wrapper = (QueryWrapper)wrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((list = this.service.list((Wrapper)wrapper)) != null && list.size() != 0) {
            return CommonResponse.error((String)"\u8ba2\u5355\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalesVO vo = (SalesVO)BeanMapper.map((Object)((Object)entity), SalesVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesVO> queryDetail(Long id) {
        SalesEntity entity = (SalesEntity)((Object)this.service.selectById(id));
        SalesVO vo = (SalesVO)BeanMapper.map((Object)((Object)entity), SalesVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalesVO salesVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("salesEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("salesEmployeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = BeanMapper.mapList((Iterable)list, SalesVO.class);
        for (SalesVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0: {
                    resData.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    resData.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: 
                case 5: {
                    resData.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    resData.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    resData.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Sales-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalesData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalesVO>> refSalesData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SalesDetail-import.xlsx", (String)"\u9500\u552e\u8ba2\u5355-\u7269\u6599\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SalesDetailVO> successList = new ArrayList<SalesDetailVO>();
        ArrayList<SalesDetailVO> errorList = new ArrayList<SalesDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SalesDetailVO detailVO = new SalesDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = (String)datas.get(0);
                detailVO.setMaterialCode(materialCode);
                try {
                    if (ObjectUtils.isEmpty((Object)map.get(materialCode))) {
                        throw new Exception("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    }
                    detailVO.setMaterialId(((MaterialVO)map.get(materialCode)).getId());
                    detailVO.setMaterialName(((MaterialVO)map.get(materialCode)).getName());
                    detailVO.setSpec(((MaterialVO)map.get(materialCode)).getSpec());
                    detailVO.setModel(((MaterialVO)map.get(materialCode)).getModel());
                    detailVO.setUnit(((MaterialVO)map.get(materialCode)).getUnitName() != null ? ((MaterialVO)map.get(materialCode)).getUnitName() : (String)datas.get(4));
                    detailVO.setMaterialTypeId(((MaterialVO)map.get(materialCode)).getCategoryId());
                    detailVO.setMaterialTypeCode(((MaterialVO)map.get(materialCode)).getCategoryCode());
                    detailVO.setMaterialTypeName(((MaterialVO)map.get(materialCode)).getCategoryName());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (datas.get(5) == null || ((String)datas.get(5)).equals("")) {
                    detailVO.setErrorMsg("\u6570\u91cf\u672a\u586b\u5199\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    detailVO.setMaterialNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(5))));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (datas.get(6) == null || ((String)datas.get(6)).equals("")) {
                    detailVO.setErrorMsg("\u5355\u4ef7\u672a\u586b\u5199\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    BigDecimal materialPrice = BigDecimal.valueOf(Double.parseDouble((String)datas.get(6)));
                    detailVO.setMaterialPrice(materialPrice);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5355\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setMaterialSumPrice(detailVO.getMaterialNum().multiply(detailVO.getMaterialPrice()));
                String memo = (String)datas.get(8);
                detailVO.setMemo(memo);
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/getContractSales"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesListVO> getContractSales(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        List salesList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)salesList, SalesVO.class);
        BigDecimal countMny = list.size() > 0 ? list.stream().map(e -> e.getOrderMny()).reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        SalesListVO salesListVO = new SalesListVO();
        salesListVO.setCountMny(countMny);
        salesListVO.setSalesList(list);
        return CommonResponse.success((Object)salesListVO);
    }
}

