package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.asset.bean.HandleDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.HandleEntity;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.service.IHandleDetailService;
import com.ejianc.business.jlprogress.asset.service.IHandleService;
import com.ejianc.business.jlprogress.asset.service.IRecordService;
import com.ejianc.business.jlprogress.asset.vo.HandleDetailVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IHandleService handleService;
	@Autowired
	private IHandleDetailService handleDetailService;
	@Autowired
	private IRecordService recordService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//根据当前单据id获取单据信息
		HandleEntity handleEntity = handleService.getById(billId);
		//根据当前单据id获取单据明细信息
		LambdaQueryWrapper<HandleDetailEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(HandleDetailEntity::getHandleId, billId);
		List<HandleDetailEntity> handleDetailEntities = handleDetailService.list(wrapper);
		for (HandleDetailEntity handleDetailEntity : handleDetailEntities) {
			//向记录表写入数据
			RecordEntity recordEntity = new RecordEntity();
			recordEntity.setSourceId(billId);
			recordEntity.setSourceBillCode(handleEntity.getBillCode());
			recordEntity.setOrgId(handleEntity.getOrgId());
			recordEntity.setOrgName(handleEntity.getOrgName());
			recordEntity.setOrgCode(handleEntity.getOrgCode());
			recordEntity.setMaterialTypeId(handleDetailEntity.getMaterialTypeId());
			recordEntity.setMaterialTypeCode(handleDetailEntity.getMaterialTypeCode());
			recordEntity.setMaterialTypeName(handleDetailEntity.getMaterialTypeName());
			recordEntity.setMaterialId(handleDetailEntity.getMaterialId());
			recordEntity.setMaterialCode(handleDetailEntity.getMaterialCode());
			recordEntity.setMaterialName(handleDetailEntity.getMaterialName());
			recordEntity.setSpec(handleDetailEntity.getSpec());
			recordEntity.setModel(handleDetailEntity.getModel());
			recordEntity.setUnit(handleDetailEntity.getUnit());
			recordEntity.setRecordType(4);
			recordEntity.setRecordDate(handleDetailEntity.getDetailHandleDate());
			recordEntity.setNum(handleDetailEntity.getHandleNum().negate());
			recordEntity.setState(1);
			recordEntity.setEmployeeId(handleEntity.getEmployeeId());
			recordEntity.setEmployeeName(handleEntity.getEmployeeName());
			recordEntity.setPrice(handleDetailEntity.getPrice());
			recordEntity.setMny(handleDetailEntity.getDetailHandleMny().negate());
			recordEntity.setSourceBillId(handleDetailEntity.getSourceId());
			recordService.saveOrUpdate(recordEntity);
		}
		

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LambdaQueryWrapper<RecordEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(RecordEntity::getSourceId, billId);
		RecordEntity result = recordService.getOne(wrapper);
		result.setDr(1);
		recordService.save(result);

		return CommonResponse.success();
	}

}
