package com.ejianc.business.jlprogress.labor.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.labor.bean.ProjectTeamEntity;
import com.ejianc.business.jlprogress.labor.enums.CheckPhotoFlagEnum;
import com.ejianc.business.jlprogress.labor.enums.LastFlagEnum;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.labor.bean.WorkRecordEntity;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.vo.WorkRecordVO;

/**
 * 劳务实名制-用工记录
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("workRecord")
public class WorkRecordController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    // 用工记录用工合同附件类型
    private static final String WORK_RECORD_CONTRACT_SOURCE_TYPE = "workRecord001";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWorkRecordService service;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectArchiveApi projectApi;
//    @Autowired
//    private IWorkerService workerService;
    @Autowired
    private IAttachmentApi attachmentApi;

//    @Autowired
//    private IOrgTeamService orgTeamService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkRecordVO> saveOrUpdate(@RequestBody WorkRecordVO saveOrUpdateVO) {
        WorkRecordVO recordVO = service.updateWorkRecord(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", recordVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkRecordVO> queryDetail(Long id) {
        WorkRecordEntity entity = service.selectById(id);
        WorkRecordVO vo = BeanMapper.map(entity, WorkRecordVO.class);
        //查询当前的用工记录(什么维度  ??)
        QueryWrapper<WorkRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

        if (entity.getPhone() != null) {
            queryWrapper.eq("phone", entity.getPhone());
        }
        if (entity.getIdCard() != null) {
            queryWrapper.eq("id_card", entity.getIdCard());
        }
        queryWrapper.orderByDesc("enter_date");
        List<WorkRecordEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<WorkRecordVO> recordVOS = BeanMapper.mapList(list, WorkRecordVO.class);
            JSONObject fileParam = new JSONObject();
            List<Long> sourceIds = recordVOS.stream().map(WorkRecordVO::getId).collect(Collectors.toList());
            fileParam.put("sourceIds", sourceIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add(WORK_RECORD_CONTRACT_SOURCE_TYPE);
            fileParam.put("sourceTypeList", JSONObject.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)) {
                for (WorkRecordVO workRecordVO : recordVOS) {
                    List<AttachmentVO> collect = fileData.stream().filter(u -> u.getSourceId().equals(workRecordVO.getId())).collect(Collectors.toList());
                    logger.info(JSONObject.toJSONString(collect));
                    workRecordVO.setSubContractFileList(collect);
                }
            }
            vo.setRecordList(recordVOS);
        }
        vo.setBillState(0);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkRecordVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("projectId") && !param.getParams().containsKey("teamId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("teamId")) {
            fuzzyFields.add("team_id");
            Parameter teamId = param.getParams().get("teamId");
            param.getParams().put("teamId", new Parameter(QueryParam.LIKE, teamId.getValue()));
        }
        param.getOrderMap().putIfAbsent("enter_date", QueryParam.DESC);
        IPage<WorkRecordEntity> page = service.queryPage(param, false);
        IPage<WorkRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkRecordVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WorkRecordVO>> iPageCommonResponse = queryList(param);
        List<WorkRecordVO> records = new ArrayList<>();
        if (iPageCommonResponse.isSuccess() && iPageCommonResponse.getData() != null) {
            records = iPageCommonResponse.getData().getRecords();
        }
        //:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        for (WorkRecordVO vo : records) {
            if (vo.getSex() != null) {
                vo.setSexName(vo.getSex() == 1 ? "男" : "女");
            }
            vo.setEnterExitStateName(vo.getEnterExitState() == 1 ? "在场" : "退场");
            if (vo.getIdCardFrontPhotoFlag() != null) {
                vo.setIdCardFrontPhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode(vo.getIdCardFrontPhotoFlag()).getDescription());
            }
            if (vo.getIdCardBackPhotoFlag() != null) {
                vo.setIdCardBackPhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode(vo.getIdCardBackPhotoFlag()).getDescription());
            }
            if (vo.getFacePhotoFlag() != null) {
                vo.setFacePhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode(vo.getFacePhotoFlag()).getDescription());
            }
        }
        beans.put("records", records);
        ExcelExport.getInstance().export("WorkRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWorkRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordData(
            @RequestParam(defaultValue = "1") int pageNumber,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String relyCondition,
            @RequestParam(required = false) String searchText,
            @RequestParam(required = false) String condition,
            @RequestParam(required = false) String searchObject) {
        Long teamId = null;
        if (StringUtils.isNotBlank(relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            ProjectTeamEntity team = projectTeamService.getById(teamId);
            if (teamId == null) {
                return CommonResponse.error("当前班组不存在档案！");
            }
            //如果是根班组不需要过滤，因为有的人员所属班组为空也在根班组下面
            teamId = team.getParentId() == null ? null : teamId;
        }
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 在场人员 最新 */
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("last_flag", new Parameter(QueryParam.EQ, LastFlagEnum.是.getStatus()));
        param.getParams().put("enter_exit_state", new Parameter(QueryParam.EQ, 1));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if (teamId != null) {
            param.getParams().put("team_id", new Parameter(QueryParam.LIKE, teamId));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("enter_date", "desc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);

        IPage<WorkRecordEntity> page = service.queryPage(param, false);
        IPage<WorkRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkRecordVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @RequestMapping(value = "/refWorkRecordDataToLab", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(
            @RequestParam(defaultValue = "1") int pageNumber,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = false) String relyCondition,
            @RequestParam(required = false) String searchText,
            @RequestParam(required = false) String condition,
            @RequestParam(required = false) String searchObject) throws ParseException {
        return service.refWorkRecordDataToLab(pageNumber, pageSize, relyCondition, searchText, condition, searchObject);
    }


    /**
     * 1、只引入人员：只引入人员信息，如人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
     * 2、引入人员及班组：同时引入人员与班组，当人员对应班组在项目中存在时，则不需要引入，直接挂项目对应班组即可；
     *
     * @return
     */
//    @RequestMapping(value = "/insertWorkRecord", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> insertWorkRecord(@RequestBody List<WorkerVO> vos) {
//        List<String> errorMsg = new ArrayList<>();
//        List<WorkRecordVO> saveVoList = new ArrayList<>();
//        List<Long> enterIdS = new ArrayList<>();
//        //获取项目数据
//        if (CollectionUtils.isNotEmpty(vos)) {
//            Long projectId = vos.get(0).getRuteProjectId();
//            CommonResponse<ProjectRegisterVO> projectDetail = projectApi.queryProjectDetail(projectId);
//            if (!projectDetail.isSuccess()) {
//                throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
//            }
//            ProjectRegisterVO project = projectDetail.getData();
//            //获取 项目根班组
//            QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
//            queryProject.eq("project_id", project.getId());
//            queryProject.isNull("parent_id");
//            ProjectTeamEntity projectTeam = projectTeamService.getOne(queryProject);
//            for (WorkerVO vo : vos) {
//                //当项目班组中该人员在场的情况下，不可引入
//                //查询 当前人员是否存在入场单
//                LambdaQueryWrapper<WorkRecordEntity> lambdaCount = new LambdaQueryWrapper<>();
//                lambdaCount.eq(WorkRecordEntity::getProjectId, projectTeam.getProjectId());
//                if (vo.getPhone() != null) {
//                    lambdaCount.eq(WorkRecordEntity::getPhone, vo.getPhone());
//                }
//                if (vo.getIdCard() != null) {
//                    lambdaCount.eq(WorkRecordEntity::getIdCard, vo.getIdCard());
//                }
//                lambdaCount.eq(WorkRecordEntity::getEnterExitState, 1);
//                lambdaCount.eq(WorkRecordEntity::getLastFlag, 1);
//                int count = service.count(lambdaCount);
//                if (count > 0) {
//                    errorMsg.add("项目班组中该人员【" + vo.getName() + "】已经在场，无法再次引入！");
//                } else {
//                    // 将VO转换为用工记录
//                    WorkRecordVO record = BeanMapper.map(vo, WorkRecordVO.class);
//                    record.setId(IdWorker.getId());
//                    record.setWorkerId(vo.getId());
//                    record.setOrgTeamId(vo.getTeamId());
//                    record.setOrgTeamName(vo.getTeamName());
//                    record.setOrgWorkType(vo.getWorkType());
//                    record.setOrgWorkTypeName(vo.getWorkTypeName());
//                    record.setProjectAddress(project.getAddress());
//                    record.setSourceFlag(2);
//                    record.setSourceFlagName("公司花名册");
//                    record.setSourceId(vo.getId());
//                    record.setEnterExitState(1);
//                    record.setEmployeeName(UserContext.getUserContext().getEmployeeName());
//                    record.setEmployeeId(UserContext.getUserContext().getEmployeeId());
//                    //设置项目信息
//                    record.setProjectId(project.getId());
//                    record.setProjectName(project.getName());
//                    record.setOrgId(project.getProjectDepartmentId());
//                    record.setParentOrgId(project.getOrgId());
//                    record.setParentOrgName(project.getOrgName());
//                    record.setProjectAddress(project.getAddress());
//                    // 人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
//                    if (StringUtils.isNotEmpty(vo.getTeamId())) {
//                        List<String> teamIdS = Arrays.asList(vo.getTeamId().split(","));
//                        //去查询班组是否存在
//                        LambdaQueryWrapper<ProjectTeamEntity> teamLambda = new LambdaQueryWrapper<>();
//                        teamLambda.eq(ProjectTeamEntity::getProjectId, project.getId());
//                        teamLambda.in(ProjectTeamEntity::getId, teamIdS);
//                        teamLambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
//                        List<ProjectTeamEntity> list = projectTeamService.list(teamLambda);
//                        if (CollectionUtils.isNotEmpty(list)) {
//                            String teamId = list.stream().map(ProjectTeamEntity::getId).collect(Collectors.toList()).
//                                    stream().map(Objects::toString).collect(Collectors.joining(","));
//                            String teamName = list.stream().map(ProjectTeamEntity::getName).collect(Collectors.toList()).
//                                    stream().map(Objects::toString).collect(Collectors.joining(","));
//                            record.setTeamId(teamId);
//                            record.setTeamName(teamName);
//                        } else {
//                            record.setTeamId(null);
//                            record.setTeamName(null);
//                        }
//                    }
//                    enterIdS.add(vo.getId());
//                    saveVoList.add(record);
//                }
//            }
//        }
//        if (CollectionUtils.isNotEmpty(saveVoList)) {
//            // 保存 推送数据到用工记录单 进场单
//            service.insertWorkRecord(saveVoList);
//            workerService.updateEnterStatusByIdS(enterIdS);
//        }
//        if (errorMsg.size() > 0) {
//            return CommonResponse.error(errorMsg.toString());
//        }
//        return CommonResponse.success("引入成功");
//    }


//    @RequestMapping(value = "/insertWorkAndTeamRecord", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> insertWorkAndTeamRecord(@RequestBody List<WorkerVO> vos) {
//        List<String> errorMsg = new ArrayList<>();
//        List<WorkRecordVO> saveVoList = new ArrayList<>();
//        List<Long> enterIdS = new ArrayList<>();
//        //获取项目数据
//        if (CollectionUtils.isNotEmpty(vos)) {
//            Long projectId = vos.get(0).getRuteProjectId();
//            CommonResponse<ProjectRegisterVO> projectDetail = projectApi.queryProjectDetail(projectId);
//            if (!projectDetail.isSuccess()) {
//                throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
//            }
//            ProjectRegisterVO project = projectDetail.getData();
//            //获取 项目根班组
//            QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
//            queryProject.eq("project_id", project.getId());
//            queryProject.isNull("parent_id");
//            ProjectTeamEntity projectTeam = projectTeamService.getOne(queryProject);
//            List<String> collect = vos.stream().map(WorkerVO::getTeamId).collect(Collectors.toList());
//            Set<String> teamIds = new HashSet<>();
//            for (String s : collect) {
//                if (StringUtils.isNotEmpty(s)) {
//                    List<String> strings = Arrays.asList(s.split(","));
//                    for (String ss : strings) {
//                        teamIds.add(ss);
//                    }
//                }
//            }
//            if (!teamIds.isEmpty()) {
//                List<OrgTeamEntity> orgTeamEntities = (List<OrgTeamEntity>) orgTeamService.listByIds(teamIds);
//                logger.info("需要引入的班组:{}", JSONObject.toJSONString(orgTeamEntities));
//                List<ProjectTeamVO> voList = new ArrayList<>();
//                for (OrgTeamEntity team : orgTeamEntities) {
//                    if (team.getParentId() != null) {
//                        ProjectTeamVO projectTeamVO = new ProjectTeamVO();
//                        projectTeamVO.setName(team.getName());
//                        projectTeamVO.setSourceParentId(team.getParentId());
//                        projectTeamVO.setParentName(team.getParentName());
//                        projectTeamVO.setParentCode(team.getParentCode());
//                        projectTeamVO.setLeaderName(team.getLeaderName());
//                        projectTeamVO.setPhone(team.getPhone());
//                        projectTeamVO.setInnerCode(team.getInnerCode());
//                        projectTeamVO.setSourceFlag(1);
//                        projectTeamVO.setProjectId(project.getId());
//                        projectTeamVO.setSourceOrgTeamId(team.getId());
//                        voList.add(projectTeamVO);
//                    }
//                }
//                if (CollectionUtils.isNotEmpty(voList)) {
//                    errorMsg = projectTeamService.insertBatch(voList);
//                }
//            }
//            for (WorkerVO vo : vos) {
//                // 当项目班组中该人员在场的情况下，不可引入
//                //查询 当前人员是否存在入场单
//                LambdaQueryWrapper<WorkRecordEntity> lambdaCount = new LambdaQueryWrapper<>();
//                lambdaCount.eq(WorkRecordEntity::getProjectId, projectTeam.getProjectId());
//                if (vo.getPhone() != null) {
//                    lambdaCount.eq(WorkRecordEntity::getPhone, vo.getPhone());
//                }
//                if (vo.getIdCard() != null) {
//                    lambdaCount.eq(WorkRecordEntity::getIdCard, vo.getIdCard());
//                }
//                lambdaCount.eq(WorkRecordEntity::getEnterExitState, 1);
//                lambdaCount.eq(WorkRecordEntity::getLastFlag, 1);
//                int count = service.count(lambdaCount);
//                if (count > 0) {
//                    errorMsg.add("项目班组中该人员【" + vo.getName() + "】已经在场，无法再次引入！");
//                } else {
//                    // 将VO转换为用工记录
//                    WorkRecordVO record = BeanMapper.map(vo, WorkRecordVO.class);
//                    record.setId(IdWorker.getId());
//                    record.setWorkerId(vo.getId());
//                    record.setOrgTeamId(vo.getTeamId());
//                    record.setOrgTeamName(vo.getTeamName());
//                    record.setOrgWorkType(vo.getWorkType());
//                    record.setOrgWorkTypeName(vo.getWorkTypeName());
//                    record.setProjectAddress(project.getAddress());
//                    record.setSourceFlag(2);
//                    record.setSourceFlagName("公司花名册");
//                    record.setSourceId(vo.getId());
//                    record.setEnterExitState(1);
//                    record.setEmployeeName(UserContext.getUserContext().getEmployeeName());
//                    record.setEmployeeId(UserContext.getUserContext().getEmployeeId());
//                    //设置项目信息
//                    record.setProjectId(project.getId());
//                    record.setProjectName(project.getName());
//                    record.setOrgId(project.getProjectDepartmentId());
//                    record.setParentOrgId(project.getOrgId());
//                    record.setParentOrgName(project.getOrgName());
//                    record.setProjectAddress(project.getAddress());
//                    // 人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
//                    if (StringUtils.isNotEmpty(vo.getTeamId())) {
//                        List<String> teamIdS = Arrays.asList(vo.getTeamId().split(","));
//                        //去查询班组是否存在
//                        LambdaQueryWrapper<ProjectTeamEntity> teamLambda = new LambdaQueryWrapper<>();
//                        teamLambda.eq(ProjectTeamEntity::getProjectId, project.getId());
//                        teamLambda.in(ProjectTeamEntity::getSourceOrgTeamId, teamIdS);
//                        teamLambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
//                        List<ProjectTeamEntity> list = projectTeamService.list(teamLambda);
//                        if (CollectionUtils.isNotEmpty(list)) {
//                            String teamId = list.stream().map(ProjectTeamEntity::getId).collect(Collectors.toList()).
//                                    stream().map(Objects::toString).collect(Collectors.joining(","));
//                            String teamName = list.stream().map(ProjectTeamEntity::getName).collect(Collectors.toList()).
//                                    stream().map(Objects::toString).collect(Collectors.joining(","));
//                            record.setTeamId(teamId);
//                            record.setTeamName(teamName);
//                        } else {
//                            record.setTeamId(null);
//                            record.setTeamName(null);
//                        }
//                    }
//                    enterIdS.add(vo.getId());
//                    saveVoList.add(record);
//                }
//            }
//        }
//        if (CollectionUtils.isNotEmpty(saveVoList)) {
//            // 保存 推送数据到用工记录单 进场单
//            service.insertWorkRecord(saveVoList);
//            workerService.updateEnterStatusByIdS(enterIdS);
//        }
//        if (errorMsg.size() > 0) {
//            return CommonResponse.error(errorMsg.toString());
//        }
//        return CommonResponse.success("引入成功");
//    }


    @RequestMapping(value = "/updateBatWorker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkRecordVO> updateBatWorker(@RequestBody WorkRecordVO updateVO) {
        WorkRecordVO vo = service.updateBatWorker(updateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
