package com.ejianc.business.jlprogress.order.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.vo.PlanDetailVO;
import com.ejianc.business.jlprogress.order.vo.SalesDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.javassist.runtime.Desc;
import org.jboss.marshalling.SimpleDataInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.order.bean.PlanEntity;
import com.ejianc.business.jlprogress.order.service.IPlanService;
import com.ejianc.business.jlprogress.order.vo.PlanVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 订单及运单-计划通知-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("plan")
public class PlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPlanService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO saveOrUpdateVO) {
        PlanEntity entity = BeanMapper.map(saveOrUpdateVO, PlanEntity.class);
        String billCode = entity.getBillCode();
        QueryWrapper<PlanEntity> wrapper = new QueryWrapper<PlanEntity>().eq("bill_code", billCode);
        if (entity.getId() != null) {
            wrapper = wrapper.ne("id", entity.getId());
        }
        List<PlanEntity> list = service.list(wrapper);
        if (list != null && list.size() != 0) {
            return CommonResponse.error("计划单号已存在");
        }
        service.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = service.selectById(id);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanEntity> page = service.queryPage(param, false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanEntity> list = service.queryList(param);
        List<PlanVO> resDatas = BeanMapper.mapList(list, PlanVO.class);
        for (PlanVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plan-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        List<Integer> list = new ArrayList<>();
        list.add(1);
        list.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, list));
        LinkedHashMap hashMap = new LinkedHashMap();
        hashMap.put("createTime", "desc");
        param.setOrderMap(hashMap);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanEntity> page = service.queryPage(param, false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PlanDetail-import.xlsx", "计划通知-物料明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlanDetailVO> successList = new ArrayList<>();
        List<PlanDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes = iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
                if (!materialRes.isSuccess()) {
                    return CommonResponse.error(materialRes.getMsg());
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));


                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlanDetailVO detailVO = new PlanDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(0);
                    detailVO.setMaterialCode(materialCode);
                    //材料code  材料Id赋值
                    try {

                        if (ObjectUtils.isEmpty(map.get(materialCode))) {
                            throw new Exception("没有此材料！");
                        }

                        detailVO.setMaterialId(map.get(materialCode).getId());
                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                        detailVO.setUnit(map.get(materialCode).getUnitName());
                        detailVO.setMaterialTypeId(map.get(materialCode).getCategoryId());
                        detailVO.setMaterialTypeCode(map.get(materialCode).getCategoryCode());
                        detailVO.setMaterialTypeName(map.get(materialCode).getCategoryName());


                    } catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //数量  校验赋值
                    try {
                        detailVO.setMaterialNum(BigDecimal.valueOf(Double.parseDouble(datas.get(5))));
                    } catch (Exception e) {
                        detailVO.setErrorMsg("数量不能为空或数量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //交货日期  校验赋值
                    try {
                        Date detailDeliveryDate = new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(6));
                        detailVO.setDetailDeliveryDate(detailDeliveryDate);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("交货日期不能为空或交货日期格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //是否停产 校验赋值
                    if (datas.get(7).equals("是")) {
                        Boolean flag = true;
                        detailVO.setIsStop(flag);
                    } else if (datas.get(7).equals("否")) {
                        Boolean flag = false;
                        detailVO.setIsStop(flag);
                    } else if ("".equals(datas.get(7)) || datas.get(7) == null) {
                        Boolean flag = null;
                        detailVO.setIsStop(flag);
                    } else {
                        detailVO.setErrorMsg("是否停产格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }


                    //已生产数量  校验赋值
                    if (datas.get(8) == null || datas.get(8) == "") {
                        detailVO.setMaterialProduceNum(null);

                    } else if (datas.get(8) != null) {
                        try {
                            detailVO.setMaterialProduceNum(BigDecimal.valueOf(Double.parseDouble(datas.get(8))));
                        } catch (Exception e) {
                            detailVO.setErrorMsg("已生产数量格式错误！");
                            errorList.add(detailVO);
                            continue;
                        }
                    }



/*                    //给备注值
                    String memo = datas.get(7);
                    detailVO.setMemo(memo);*/
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
