package com.ejianc.business.jlprogress.progress.utils;

import PluSoft.Utils.Convert;
import PluSoft.Utils.StringUtil;
import com.ejianc.business.jlprogress.progress.cons.CustomizeCloumVO;
import com.ejianc.business.jlprogress.progress.cons.PlanCloumCons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Export {

	//导出自定义字段
	public static void exportExtendedAttributes(HashMap project, Map<String, CustomizeCloumVO> cloumMap){
		for(CustomizeCloumVO cloum : cloumMap.values()){
			exportExtendedAttribute(project, Long.valueOf(cloum.getFieldID()), cloum.getFieldName(), cloum.getField());
		}

//        //导出负责人
//        createPrincipalName(project);
//        exportExtendedAttribute(project, 188743734, "负责人", "PrincipalName");


		//...

//        ArrayList tasks = (ArrayList)project.get("Tasks");
//        HashMap task = (HashMap)tasks.get(0);
//        task.put("ProductionValue", 1234444555);
//
		//文本
//        exportExtendedAttribute(project, 188743737, "文本3", "text3");
//        exportExtendedAttribute(project, 188743740, "文本4", "text4");
//        exportExtendedAttribute(project, 188743743, "文本5", "text5");
//        exportExtendedAttribute(project, 188743746, "文本6", "text6");
//        exportExtendedAttribute(project, 188743747, "文本7", "text7");
//        exportExtendedAttribute(project, 188743748, "文本8", "text8");
//
//        //数字
//        exportExtendedAttribute(project, 188743768, "数字2", "num2");
//        exportExtendedAttribute(project, 188743769, "数字3", "num3");
//        exportExtendedAttribute(project, 188743770, "数字4", "num4");
//        exportExtendedAttribute(project, 188743771, "数字5", "num5");

	}

    //导出自定义字段
    public static void exportExtendedAttributes(HashMap project){
		exportExtendedAttributes(project, PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
    }
    
	private static void exportExtendedAttribute(HashMap project, long fieldID, String alias, String dataField)
	{
	    ArrayList tasks = (ArrayList)project.get("Tasks");
	    tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");

	    ArrayList ExtendedAttributesList = (ArrayList)project.get("ExtendedAttributes");
	    if (ExtendedAttributesList == null)
	    {
	        ExtendedAttributesList = new ArrayList();
	        project.put("ExtendedAttributes", ExtendedAttributesList);
	    }
	    
	    
	    HashMap ea1 = new HashMap();
	    ea1.put("FieldID", fieldID);
	    ea1.put("FieldName", "");
	    ea1.put("Alias", alias);
	    ExtendedAttributesList.add(ea1);
	    

	    for (Object task_o : tasks) {
			HashMap task = (HashMap)task_o;
			
	        ArrayList eas = (ArrayList)task.get("ExtendedAttribute");
	        if (eas == null) {
	        	eas = new ArrayList();   
	        	task.put("ExtendedAttribute", eas);          
	        }
	        
	        Object value = task.get(dataField);
	        if(value != null) {
		        HashMap ea = new HashMap();
		        ea.put("FieldID", fieldID);
		        ea.put("Value", value);
		        eas.add(ea);
	        }
	    }		    

	}
	
	
	//
	private static void createPrincipalName(HashMap project)
    {
        ArrayList tasks = (ArrayList)project.get("Tasks");
        tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");

        ArrayList principals = (ArrayList)project.get("Principals");
	    for (Object task_o : tasks) {
			HashMap task = (HashMap)task_o;
			
            String principal = (String)task.get("Principal");
            if (StringUtil.isNullOrEmpty(principal)) continue;

            ArrayList<String> ids = new ArrayList<String>();            
            String[] ss = principal.split(",");
            for(String id : ss) {
            	ids.add(id);
            }
            
            
            String name = "";

    	    for (Object p_o : principals) {
    			HashMap p = (HashMap)p_o;
    			
                String id = p.get("UID").toString();
                if (ids.indexOf(id) != -1)
                {
                    if (!name.equals("")) name += ",";
                    name += p.get("Name").toString();
                }
            }
    	    
            task.put("PrincipalName", name);
        }
    }

    /*
    
    文本1：   188743731       （注意：文本1默认被用掉了，请从文本2开始）       
    数字1：   188743767       
    日期1：   188743945
    
    */
	
	
	public static void exportFixedDateSummarys(HashMap project)
	{
	    ArrayList tasks = (ArrayList)project.get("Tasks");
	    tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");
	    
	    for (Object task_o : tasks) {
			HashMap task = (HashMap)task_o;
			
			int FixedDate = Convert.toInt(task.get("FixedDate"));
            int Summary = Convert.toInt(task.get("Summary"));
            if (FixedDate == 1 && Summary == 1)
            {
                task.put("Manual", 1);
            }			
	    }
	}
	
}
