/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.asset.service.impl;

import com.ejianc.business.jlprogress.asset.bean.AllotDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.AllotEntity;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.mapper.AllotMapper;
import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.service.IAllotService;
import com.ejianc.business.jlprogress.asset.service.IRecordService;
import com.ejianc.business.jlprogress.asset.vo.AllotVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotService")
public class AllotServiceImpl
extends BaseServiceImpl<AllotMapper, AllotEntity>
implements IAllotService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private IRecordService recordService;
    private static final String BILL_CODE = "ALLOT_CODE";

    @Override
    public CommonResponse<AllotVO> insertOrUpdate(AllotVO saveOrUpdateVO) {
        AllotEntity entity = (AllotEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        this.recordMapper.deleteBySourceId(entity.getId());
        ArrayList<RecordEntity> recordList = new ArrayList<RecordEntity>();
        for (AllotDetailEntity detailEntity : entity.getAllotDetailList()) {
            if ("del".equals(detailEntity.getRowState())) continue;
            RecordEntity record1 = new RecordEntity();
            RecordEntity record2 = new RecordEntity();
            record1.setRecordType(RecordTypeEnum.\u8c03\u62e8\u5165.getCode());
            record1.setOrgId(entity.getInOrgId());
            record1.setOrgName(entity.getInOrgName());
            record1.setOrgCode(entity.getInOrgCode());
            record1.setInoutOrgId(entity.getOrgId());
            record1.setInoutOrgName(entity.getOrgName());
            record1.setInoutOrgCode(entity.getOrgCode());
            record1.setNum(detailEntity.getAllotNum());
            record1.setMny(detailEntity.getDetailAllotMny());
            record2.setRecordType(RecordTypeEnum.\u8c03\u62e8\u51fa.getCode());
            record2.setOrgId(entity.getOrgId());
            record2.setOrgName(entity.getOrgName());
            record2.setOrgCode(entity.getOrgCode());
            record2.setInoutOrgId(entity.getInOrgId());
            record2.setInoutOrgName(entity.getInOrgName());
            record2.setInoutOrgCode(entity.getInOrgCode());
            record2.setNum(detailEntity.getAllotNum().negate());
            record2.setMny(detailEntity.getDetailAllotMny().negate());
            record1.setSourceId(entity.getId());
            record1.setSourceBillCode(detailEntity.getSourceBillCode());
            record1.setSourceBillId(detailEntity.getSourceId());
            record1.setMaterialId(detailEntity.getMaterialId());
            record1.setMaterialName(detailEntity.getMaterialName());
            record1.setMaterialCode(detailEntity.getMaterialCode());
            record1.setMaterialTypeId(detailEntity.getMaterialTypeId());
            record1.setMaterialTypeName(detailEntity.getMaterialTypeName());
            record1.setMaterialTypeCode(detailEntity.getMaterialTypeCode());
            record1.setSpec(detailEntity.getSpec());
            record1.setModel(detailEntity.getModel());
            record1.setUnit(detailEntity.getUnit());
            record1.setState(0);
            record1.setEmployeeId(entity.getEmployeeId());
            record1.setEmployeeName(entity.getEmployeeName());
            record1.setPrice(detailEntity.getPrice());
            record1.setAllotBillCode(entity.getBillCode());
            record2.setSourceId(entity.getId());
            record2.setSourceBillCode(detailEntity.getSourceBillCode());
            record2.setSourceBillId(detailEntity.getSourceId());
            record2.setMaterialId(detailEntity.getMaterialId());
            record2.setMaterialName(detailEntity.getMaterialName());
            record2.setMaterialCode(detailEntity.getMaterialCode());
            record2.setMaterialTypeId(detailEntity.getMaterialTypeId());
            record2.setMaterialTypeName(detailEntity.getMaterialTypeName());
            record2.setMaterialTypeCode(detailEntity.getMaterialTypeCode());
            record2.setSpec(detailEntity.getSpec());
            record2.setModel(detailEntity.getModel());
            record2.setUnit(detailEntity.getUnit());
            record2.setState(0);
            record2.setEmployeeId(entity.getEmployeeId());
            record2.setEmployeeName(entity.getEmployeeName());
            record2.setPrice(detailEntity.getPrice());
            record2.setAllotBillCode(entity.getBillCode());
            recordList.add(record1);
            recordList.add(record2);
        }
        this.recordService.saveOrUpdateBatch(recordList);
        AllotVO vo = (AllotVO)BeanMapper.map((Object)((Object)entity), AllotVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

