/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.mapper.DetectReportMapper;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.vo.DetectReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="detectReportService")
public class DetectReportServiceImpl
extends BaseServiceImpl<DetectReportMapper, DetectReportEntity>
implements IDetectReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "JCBG";

    @Override
    public DetectReportVO saveOrUpdate(DetectReportVO saveOrUpdateVO) {
        DetectReportEntity entity = (DetectReportEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DetectReportEntity.class));
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            this.checkCode(entity);
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == entity.getReferenceFlag()) {
            entity.setReferenceFlag(0);
        }
        super.saveOrUpdate((Object)entity, false);
        DetectReportVO vo = (DetectReportVO)BeanMapper.map((Object)((Object)entity), DetectReportVO.class);
        return vo;
    }

    public void checkCode(DetectReportEntity entity) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_code", (Object)entity.getBillCode());
        queryWrapper.eq((Object)"dr", (Object)0);
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)queryWrapper)))) {
            throw new BusinessException("\u68c0\u67e5\u62a5\u544a\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }
}

