/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.asset.bean.HandleDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.HandleEntity;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.service.IHandleDetailService;
import com.ejianc.business.jlprogress.asset.service.IHandleService;
import com.ejianc.business.jlprogress.asset.service.IRecordService;
import com.ejianc.business.jlprogress.asset.vo.HandleDetailVO;
import com.ejianc.business.jlprogress.asset.vo.HandleVO;
import com.ejianc.business.jlprogress.asset.vo.RecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IHandleService handleService;
    @Autowired
    private IHandleDetailService handleDetailService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private RecordMapper recordMapper;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity entity = (HandleEntity)((Object)this.handleService.selectById(billId));
        HandleVO saveOrUpdateVO = (HandleVO)BeanMapper.map((Object)((Object)entity), HandleVO.class);
        List<Long> sourceIds = saveOrUpdateVO.getHandleDetailList().stream().map(HandleDetailVO::getSourceId).collect(Collectors.toList());
        List<RecordVO> useNumList = this.recordMapper.queryUseNumList(entity.getOrgId(), sourceIds);
        Map<String, BigDecimal> useNumMap = useNumList.stream().collect(Collectors.toMap(recordVO -> recordVO.getOrgId().toString() + recordVO.getMaterialId().toString() + recordVO.getSourceBillId().toString(), RecordVO::getUseNum));
        for (HandleDetailEntity detailEntity : entity.getHandleDetailList()) {
            if (detailEntity.getMaterialNum().compareTo(detailEntity.getHandleNum()) < 0) {
                return CommonResponse.error((String)("\u7269\u6599" + detailEntity.getMaterialName() + "\u5904\u7f6e\u6570\u91cf\u8d85\u51fa\u53ef\u7528\u6570\u91cf"));
            }
            String key = entity.getOrgId().toString() + detailEntity.getMaterialId().toString() + detailEntity.getSourceId();
            if (detailEntity.getMaterialNum().compareTo(useNumMap.get(key)) == 0) continue;
            return CommonResponse.error((String)("\u7269\u6599" + detailEntity.getMaterialName() + "\u7269\u6599\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7f6e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.handleService.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(HandleDetailEntity::getHandleId, (Object)billId);
        List handleDetailEntities = this.handleDetailService.list((Wrapper)wrapper);
        ArrayList<RecordEntity> recordEntities = new ArrayList<RecordEntity>();
        for (HandleDetailEntity handleDetailEntity : handleDetailEntities) {
            RecordEntity recordEntity = new RecordEntity();
            recordEntity.setSourceId(billId);
            recordEntity.setSourceBillCode(handleDetailEntity.getSourceBillCode());
            recordEntity.setOrgId(handleEntity.getOrgId());
            recordEntity.setOrgName(handleEntity.getOrgName());
            recordEntity.setOrgCode(handleEntity.getOrgCode());
            recordEntity.setMaterialTypeId(handleDetailEntity.getMaterialTypeId());
            recordEntity.setMaterialTypeCode(handleDetailEntity.getMaterialTypeCode());
            recordEntity.setMaterialTypeName(handleDetailEntity.getMaterialTypeName());
            recordEntity.setMaterialId(handleDetailEntity.getMaterialId());
            recordEntity.setMaterialCode(handleDetailEntity.getMaterialCode());
            recordEntity.setMaterialName(handleDetailEntity.getMaterialName());
            recordEntity.setSpec(handleDetailEntity.getSpec());
            recordEntity.setModel(handleDetailEntity.getModel());
            recordEntity.setUnit(handleDetailEntity.getUnit());
            recordEntity.setRecordType(RecordTypeEnum.\u5904\u7f6e.getCode());
            recordEntity.setRecordDate(handleDetailEntity.getDetailHandleDate());
            recordEntity.setNum(handleDetailEntity.getHandleNum().negate());
            recordEntity.setState(1);
            recordEntity.setEmployeeId(handleEntity.getEmployeeId());
            recordEntity.setEmployeeName(handleEntity.getEmployeeName());
            recordEntity.setPrice(handleDetailEntity.getPrice());
            recordEntity.setMny(handleDetailEntity.getDetailHandleMny().negate());
            recordEntity.setSourceBillId(handleDetailEntity.getSourceId());
            recordEntities.add(recordEntity);
        }
        this.recordService.saveOrUpdateBatch(recordEntities);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(billId);
        this.recordService.deleteBatch(list);
        return CommonResponse.success();
    }
}

