/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlprogress.labor.bean.WorkRecordEntity;
import com.ejianc.business.jlprogress.labor.bean.WorkerEnterEntity;
import com.ejianc.business.jlprogress.labor.mapper.WorkerEnterMapper;
import com.ejianc.business.jlprogress.labor.service.IAttendanceService;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.service.IWorkerEnterService;
import com.ejianc.business.jlprogress.labor.vo.WorkRecordVO;
import com.ejianc.business.jlprogress.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workerEnterService")
public class WorkerEnterServiceImpl
extends BaseServiceImpl<WorkerEnterMapper, WorkerEnterEntity>
implements IWorkerEnterService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RECORD_BILL_TYPE = "EJCBT202405000065";
    private static final String ENTER_BILL_TYPE = "EJCBT202405000066";
    private static final String WORKER_BILL_TYPE = "EJCBT202405000028";
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";
    private static final String IDBACK_TYPE = "idCardBack";
    private static final String FACE_TYPE = "face";
    private static final String ORDER_TYPE = "desc";
    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";
    private static final String RECORD_CON_SOURCE_TYPE = "workRecord001";
    private static final String ENTER_CON_SOURCE_TYPE = "wokerEnter002";
    private static final String BILL_CODE = "LABOR_WORKER_ENTER";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private IAttendanceService attachmentService;

    @Override
    public WorkerEnterVO saveOrUpdate(WorkerEnterVO saveOrUpdateVO) {
        WorkerEnterEntity entity = (WorkerEnterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkerEnterEntity.class));
        if (entity.getWorkType() != null && entity.getWorkType().isEmpty()) {
            entity.setWorkType(null);
            entity.setWorkTypeName(null);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getSourceFlag() == 1) {
                entity.setSourceFlagName("\u81ea\u5236");
            }
            if (entity.getSourceFlag() == 2) {
                entity.setSourceFlagName("\u516c\u53f8\u82b1\u540d\u518c");
            }
            if (entity.getSourceFlag() == 3) {
                entity.setSourceFlagName("\u9080\u8bf7");
            }
            if (entity.getIdCardFrontPhotoFlag() == null) {
                entity.setIdCardFrontPhotoFlag(2);
            }
            if (entity.getFacePhotoFlag() == null) {
                entity.setFacePhotoFlag(2);
            }
            entity.setChangeState(0);
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setChangeVersion(1);
        }
        super.saveOrUpdate((Object)entity, false);
        WorkerEnterVO vo = (WorkerEnterVO)BeanMapper.map((Object)((Object)entity), WorkerEnterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> saveCheck(WorkerEnterVO vo) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)vo.getPhone())) {
            QueryWrapper queryEnter = new QueryWrapper();
            queryEnter.eq((Object)"phone", (Object)vo.getPhone());
            queryEnter.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            queryEnter.eq((Object)"dr", (Object)0);
            if (vo.getId() != null) {
                queryEnter.ne((Object)"id", (Object)vo.getId());
            }
            queryEnter.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list1 = super.list((Wrapper)queryEnter);
            if (list1.size() > 0) {
                jsonObject.put("level", (Object)0);
                jsonObject.put("msg", (Object)("\u8be5\u624b\u673a\u53f7\u88ab\u8fdb\u573a\u8bb0\u5f55\u3010" + ((WorkerEnterEntity)((Object)list1.get(0))).getName() + "\u3011\u6ce8\u518c\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0!"));
                return CommonResponse.success((Object)jsonObject);
            }
        }
        QueryWrapper queryRecordCard = new QueryWrapper();
        queryRecordCard.eq((Object)"id_card", (Object)vo.getIdCard());
        queryRecordCard.eq((Object)"enter_exit_state", (Object)1);
        queryRecordCard.eq((Object)"project_id", (Object)vo.getProjectId());
        queryRecordCard.eq((Object)"last_flag", (Object)1);
        queryRecordCard.eq((Object)"dr", (Object)0);
        queryRecordCard.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List list2 = this.recordService.list((Wrapper)queryRecordCard);
        if (list2.size() > 0) {
            jsonObject.put("level", (Object)0);
            jsonObject.put("msg", (Object)"\u8be5\u52b3\u52a1\u4eba\u5458\u5df2\u5728\u573a\uff0c\u4e0d\u80fd\u91cd\u590d\u8fdb\u573a");
            return CommonResponse.success((Object)jsonObject);
        }
        QueryWrapper queryEnterByCard = new QueryWrapper();
        queryEnterByCard.eq((Object)"id_card", (Object)vo.getIdCard());
        queryEnterByCard.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (vo.getId() != null) {
            queryEnterByCard.ne((Object)"id", (Object)vo.getId());
        }
        queryEnterByCard.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list3 = super.list((Wrapper)queryEnterByCard);
        if (list3.size() > 0) {
            jsonObject.put("level", (Object)0);
            jsonObject.put("msg", (Object)("\u8be5\u4eba\u5458\u5728\u3010" + ((WorkerEnterEntity)((Object)list3.get(0))).getProjectName() + "\u3011\u4e2d\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8fdb\u573a\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u4e0a\u6b21\u8fdb\u573a\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u672c\u6b21\u8fdb\u573a\uff1b"));
            return CommonResponse.success((Object)jsonObject);
        }
        jsonObject.put("level", (Object)2);
        return CommonResponse.success((Object)jsonObject);
    }

    @Override
    public void bpmWriteBackAndInsert(WorkerEnterEntity entity) {
        boolean recordFlage = true;
        CommonResponse projectRegisterVOCommonResponse = this.projectApi.getProjectArchiveById(entity.getProjectId());
        if (!projectRegisterVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        ProjectArchiveVO project = (ProjectArchiveVO)projectRegisterVOCommonResponse.getData();
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s : typeList) {
            CommonResponse idCardResponse = this.attachmentApi.queryListBySourceId(entity.getId(), ENTER_BILL_TYPE, s, ORDER_TYPE);
            if (idCardResponse.isSuccess()) continue;
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u8bbf\u95ee\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkRecordEntity::getSourceId, (Object)entity.getId());
        List recordList = this.recordService.list((Wrapper)lambdaQuery);
        WorkRecordVO record = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        record.setId(Long.valueOf(CollectionUtils.isNotEmpty((Collection)recordList) ? ((WorkRecordEntity)((Object)recordList.get(0))).getId() : IdWorker.getId()));
        record.setWorkerId(Long.valueOf(IdWorker.getId()));
        record.setProjectTeamId(entity.getTeamId());
        record.setProjectTeamName(entity.getTeamName());
        record.setProjectWorkType(entity.getWorkType());
        record.setProjectWorkTypeName(entity.getWorkTypeName());
        record.setProjectAddress(project.getAddress());
        record.setSourceFlag(Integer.valueOf(1));
        record.setSourceFlagName("\u9879\u76ee\u8fdb\u573a");
        record.setSourceId(entity.getId());
        record.setEnterExitState(Integer.valueOf(1));
        record.setSubContractId(entity.getSubContractId());
        record.setSubContractName(entity.getSubContractName());
        record.setSupplierId(entity.getSupplierId());
        record.setSupplierName(entity.getSupplierName());
        record.setEnterDate(entity.getEnterDate());
        record.setEmployeeId(entity.getEmployeeId());
        record.setEmployeeName(entity.getEmployeeName());
        record.setProjectId(entity.getProjectId());
        record.setProjectName(entity.getProjectName());
        record.setOrgId(entity.getOrgId());
        record.setParentOrgId(entity.getParentOrgId());
        record.setParentOrgName(entity.getParentOrgName());
        ArrayList<WorkRecordVO> saveVoList = new ArrayList<WorkRecordVO>();
        saveVoList.add(record);
        List<WorkRecordVO> recordVOS = this.recordService.insertWorkRecord(saveVoList);
        WorkRecordVO recordVO = recordVOS.get(0);
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(Long.toString(entity.getId()), ENTER_BILL_TYPE, ENTER_CON_SOURCE_TYPE, Long.toString(recordVO.getId()), RECORD_BILL_TYPE, RECORD_CON_SOURCE_TYPE);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u590d\u5236\u5931\u8d25");
        }
    }

    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return ((WorkerEnterMapper)this.baseMapper).updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }
}

