/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.handler.DurationUtil;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.service.impl.DayFillBpmServiceImpl;
import com.ejianc.business.jlprogress.progress.vo.DayFillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dayFill"})
public class DayFillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private IDayFillService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DayFillBpmServiceImpl bpmService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DayFillVO> saveOrUpdate(@RequestBody DayFillVO saveOrUpdateVO) {
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<DayFillVO> response = this.service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DayFillVO> queryDetail(Long id) {
        DayFillVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DayFillVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DayFillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("fillUserName");
        fuzzyFields.add("updateUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("structCode")) {
            Long projectId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("projectId")).getValue()));
            String structCode = String.valueOf(((Parameter)param.getParams().get("structCode")).getValue());
            param.getParams().remove("projectId");
            param.getParams().remove("structCode");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            queryParam.getParams().put("structCode", new Parameter("like_right", (Object)structCode));
            queryParam.getParams().put("showState", new Parameter("eq", (Object)1));
            queryParam.getParams().put("actualStart", new Parameter("ne", null));
            List detailList = this.detailService.queryList(queryParam);
            if (CollectionUtils.isEmpty((Collection)detailList)) {
                return CommonResponse.success((String)"\u6570\u636e\u4e3a\u7a7a\uff01", (Object)new Page());
            }
            List progressIds = detailList.stream().map(ProgressDetailEntity::getProgressId).collect(Collectors.toList());
            param.getParams().put("id", new Parameter("in", progressIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List totalPlanVOS = BeanMapper.mapList((Iterable)page.getRecords(), DayFillVO.class);
        pageData.setRecords(totalPlanVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DayFill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDayFillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DayFillVO>> refDayFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DayFillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getExecPlan"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map> exportxml(@RequestBody DayFillVO vo) {
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getExecPlan(vo));
    }

    @RequestMapping(value={"/resetExecPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DayFillVO> resetExecPlan(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.resetExecPlan(id));
    }

    @RequestMapping(value={"/getExecPlanMobile"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map> exportxmlMobile(@RequestBody DayFillVO vo) {
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getExecPlanMobile(vo));
    }

    @RequestMapping(value={"/projectDiffTypeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> projectDiffTypeList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.projectDiffTypeList(param));
    }

    @RequestMapping(value={"/exportDiffTypeList"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportDiffTypeList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject json = this.service.projectDiffTypeList(param);
        HashMap<String, JSONArray> beans = new HashMap<String, JSONArray>();
        beans.put("records", json.getJSONArray("records"));
        ExcelExport.getInstance().export("diffTypeList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/diffTypeRate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONArray> diffTypeRate(@RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.diffTypeRate(projectId));
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
        CommonResponse<String> response = this.bpmService.afterApprovalProcessor(id, null, null);
        DayFillEntity entity = (DayFillEntity)((Object)this.service.selectById(id));
        entity.setBillState(1);
        this.service.updateById((Object)entity);
        return response;
    }

    @RequestMapping(value={"/test2"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test2(@RequestParam Long id) {
        CommonResponse<String> response = this.bpmService.afterAbstainingProcessor(id, null, null);
        DayFillEntity entity = (DayFillEntity)((Object)this.service.selectById(id));
        entity.setBillState(0);
        this.service.updateById((Object)entity);
        return response;
    }
}

