package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.CheckMapper;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.service.ICheckService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单及运单-交付验收单-主表
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    @Override
    public JSONObject getCheckDataByContractId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getContractId, contractId);
        queryWrapper.in(CheckEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CheckEntity> list = list(queryWrapper);
        jsonObject.put("checkList", list);
        jsonObject.put("checkState", CollectionUtils.isNotEmpty(list) && list.size() > 0 ? "已验收" : "未验收");
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> getCheckDataByContractIdList(List<Long> ids) {
        Map<Long, JSONObject> collectMap = new HashMap<>();
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(CheckEntity::getContractId, ids);
        queryWrapper.in(CheckEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CheckEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Map<Long, List<CheckEntity>> checkDataMap  = list.stream().collect(Collectors.groupingBy(CheckEntity::getContractId));
            for (Long contractId : checkDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("checkList", checkDataMap.get(contractId));
                jsonObject.put("checkState", CollectionUtils.isNotEmpty(checkDataMap.get(contractId)) && checkDataMap.get(contractId).size() > 0 ? "已验收" : "未验收");
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}
