package com.ejianc.business.jlprogress.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
//import com.ejianc.business.jlprogress.progress.consumer.TransferVO;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.utils.WarnFeignUtil;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
//import com.ejianc.business.jlprogress.progress.bean.MonthPlanDetailEntity;
//import com.ejianc.business.jlprogress.progress.bean.MonthPlanEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
//import com.ejianc.business.jlprogress.progress.service.IMonthPlanDetailService;
//import com.ejianc.business.jlprogress.progress.service.IMonthPlanService;
import com.ejianc.framework.core.response.CommonResponse;
//import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service("dayFill") 
public class DayFillBpmServiceImpl implements ICommonBusinessService {

	private final static String COLLECT_FILL_QUEUE = "collect_zjkj_fill_queue";

	@Value("${spring.cloud.config.profile}")
	private String profile;

	@Autowired
	private IExecPlanService execPlanService;
	@Autowired
	private IExecPlanDetailService execPlanDetailService;

	@Autowired
	private IDayFillService dayFillService;

	@Autowired
	private WarnFeignUtil feignUtil;

	@Autowired
	private RabbitTemplate rabbitTemplate;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 校验日反馈是否最新，否则需要重算后审批
		DayFillEntity entity = dayFillService.selectById(billId);
		QueryWrapper ew = new QueryWrapper<ExecPlanEntity>();
		ew.eq("project_id", entity.getProjectId());
		ew.orderByDesc("fill_version");
		List<ExecPlanEntity> execList = execPlanService.list(ew);
		if(CollectionUtils.isNotEmpty(execList) && !entity.getFillVersion().equals(execList.get(0).getFillVersion())
				|| entity.getFillVersion() == null || execList.get(0).getFillVersion() == null){
			return CommonResponse.error("上游单据已被其他同事修改，请刷新后重试!");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ExecPlanEntity execPlanEntity = execPlanService.pushExecPlan(billId, PlanConstant.DAY_FILL);
//		// 推送MQ汇总
//		this.sendMq(execPlanEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 校验同一填报人，不能同时存在其他未生效单据
		DayFillEntity entity = dayFillService.selectById(billId);
		LambdaQueryWrapper<DayFillEntity> ew = new LambdaQueryWrapper<>();
		ew.eq(DayFillEntity::getProjectId, entity.getProjectId());
		ew.eq(DayFillEntity::getFillUserId, entity.getFillUserId());
		ew.notIn(DayFillEntity::getBillState, 1, 3);
		ew.ne(DayFillEntity::getId, entity.getId());
		List<DayFillEntity> list = dayFillService.list(ew);
		if (CollectionUtils.isNotEmpty(list)) {
			return CommonResponse.error("同一填报人存在其他未生效单据，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ExecPlanEntity execPlanEntity = execPlanService.pushExecPlanRollBack(billId, PlanConstant.DAY_FILL);
//		// 推送MQ汇总
//		this.sendMq(execPlanEntity);
		return CommonResponse.success();
	}

//	/**
//	 * 消息发送MQ队列成功
//	 * @param exec
//	 * @return
//	 */
//	public String sendMq(ExecPlanEntity exec) {
//
//		LambdaQueryWrapper<MonthPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
//		queryWrapper.eq(MonthPlanEntity::getProjectId,exec.getProjectId());
//		queryWrapper.eq(MonthPlanEntity::getDr,0);
//		List<MonthPlanEntity> list = monthPlanService.list(queryWrapper);
//		if (CollectionUtils.isNotEmpty(list)){
//			for (MonthPlanEntity entity : list){
//				QueryWrapper<MonthPlanDetailEntity> monthEw = new QueryWrapper<>();
//				monthEw.eq("progress_id", entity.getId());
//				monthEw.orderByAsc("tid");
//				List<MonthPlanDetailEntity> monthDetailList = monthPlanDetailService.list(monthEw);
//				entity.setAllList(monthDetailList);
//			}
//		}
//
//		MqMessage mqMessage = new MqMessage();
//		TransferVO body = feignUtil.getTransferVO(Arrays.asList(exec.getProjectId()));// 提前查询项目Map和组织Map
//		body.setExecList(Arrays.asList(exec));
//		body.setMonthList(list);
//		mqMessage.setBody(body);
//		rabbitTemplate.convertAndSend(COLLECT_FILL_QUEUE + "_" + profile, mqMessage);
//		return "消息发送MQ队列成功！";
//
//	}

}
