package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.MatCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.service.IMatCheckService;
import com.ejianc.business.jlprogress.quality.service.ISupplyService;
import com.ejianc.business.jlprogress.quality.vo.MatCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 质量检测-原材料检测记录
 *
 * @author generator
 */
@Controller
@RequestMapping("matCheck")
public class MatCheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MAT_CHECK";

    @Autowired
    private IMatCheckService service;

    @Autowired
    private ISupplyService supplyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MatCheckVO> saveOrUpdate(@RequestBody MatCheckVO saveOrUpdateVO) {
        saveOrUpdateVO.setOrgId(InvocationInfoProxy.getOrgId());
        if (StringUtils.isNotBlank(saveOrUpdateVO.getBillCode())) {
            LambdaQueryWrapper<MatCheckEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.ne(null != saveOrUpdateVO.getId(), MatCheckEntity::getId, saveOrUpdateVO.getId());
            queryWrapper.eq(MatCheckEntity::getBillCode, saveOrUpdateVO.getBillCode());
            if(service.count(queryWrapper) > 0){
                throw new BusinessException("该编码已存在!");
            }
        }

        LambdaQueryWrapper<MatCheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MatCheckEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(MatCheckEntity::getSupplyId, saveOrUpdateVO.getSupplyId());
        if(service.count(queryWrapper) > 0){
            throw new BusinessException("该供货单已被引用过!");
        }

        MatCheckEntity entity = BeanMapper.map(saveOrUpdateVO, MatCheckEntity.class);
        if (StringUtils.isBlank(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        MatCheckVO vo = BeanMapper.map(entity, MatCheckVO.class);

        LambdaUpdateWrapper<SupplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SupplyEntity::getId, saveOrUpdateVO.getSupplyId());
        updateWrapper.set(SupplyEntity::getReferenceFlag, 1);
        supplyService.update(updateWrapper);

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatCheckVO> queryDetail(Long id) {
        MatCheckEntity entity = service.selectById(id);
        MatCheckVO vo = BeanMapper.map(entity, MatCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatCheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> collect = vos.stream().map(MatCheckVO::getId).collect(Collectors.toList());
        Collection<MatCheckEntity> entities = service.listByIds(collect);

        service.removeByIds(collect, true);

        LambdaUpdateWrapper<SupplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SupplyEntity::getId, entities.stream().map(MatCheckEntity::getSupplyId).collect(Collectors.toList()));
        updateWrapper.set(SupplyEntity::getReferenceFlag, 0);
        supplyService.update(updateWrapper);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatCheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkUserName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MatCheckEntity> page = service.queryPage(param, false);
        IPage<MatCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatCheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkUserName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<MatCheckEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("MatCheck-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMatCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MatCheckVO>> refMatCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MatCheckEntity> page = service.queryPage(param, false);
        IPage<MatCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatCheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
