package com.ejianc.business.jlprogress.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.asset.bean.AllotDetailEntity;
/**
 * 浦江设备管理-调拨
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asset_allot")
public class AllotEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 调出位置id
    @TableField(value="org_name")
    private String orgName; // 调出位置名称
    @TableField(value="org_code")
    private String orgCode; // 调出位置code
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入位置id
    @TableField(value="in_org_name")
    private String inOrgName; // 调入位置名称
    @TableField(value="in_org_code")
    private String inOrgCode; // 调入位置code
    @TableField(value="asset_date")
    private Date assetDate; // 调拨日期
    @TableField(value="asset_mny")
    private BigDecimal assetMny; // 调拨金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="allotDetailService",pidName = "allotId")
    private List<AllotDetailEntity> allotDetailList = new ArrayList<>(); // 浦江设备管理-调拨详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    public Date getAssetDate() {
        return assetDate;
    }

    public void setAssetDate(Date assetDate) {
        this.assetDate = assetDate;
    }
    public BigDecimal getAssetMny() {
        return assetMny;
    }

    public void setAssetMny(BigDecimal assetMny) {
        this.assetMny = assetMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<AllotDetailEntity> getAllotDetailList() {
        return allotDetailList;
    }

    public void setAllotDetailList(List<AllotDetailEntity> allotDetailList) {
        this.allotDetailList = allotDetailList;
    }
}
