package com.ejianc.business.jlprogress.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.labor.vo.DistanceVO;

import java.util.List;

/**
 * 高德地图接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public interface IAmapService {

	/**
	 * 距离测量
	 *
	 * @param origins     出发点：支持100个坐标对，坐标对见用“| ”分隔；经度和纬度用","分隔
	 * @param destination 目的地： lon，lat（经度，纬度）， “,”分割"，如117.500244, 40.417801经纬度小数点不超过6位
	 * @param type        路径计算的方式和方法：0：直线距离 1：驾车导航距离（仅支持国内坐标）。必须指出，当为1时会考虑路况，故在不同时间请求返回结果可能不同。此策略和驾车路径规划接口的 strategy=0策略基本一致，策略为“ 速度优先，此路线不一定距离最短 ”由于算法差异，无法保证距离测量结果与路径规划结果完全一致。若需要实现高德地图客户端效果，可以考虑使用驾车路径规划接口 3：步行规划距离（仅支持5km之间的距离）
	 *
	 * @return {@link List}<{@link DistanceVO}>
	 */
	List<DistanceVO> distance(String origins, String destination, String type);


	/**
	 * 逆地理编码
	 *
	 * @param location 经纬度坐标
	 *
	 * @return {@link JSONObject}
	 */
	JSONObject regeo(String location);
}
