package com.ejianc.business.jlprogress.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.business.jlprogress.progress.mapper.DayFillDetailMapper;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 日进度计划填报详情
 * 
 * @author generator
 * 
 */
@Service("dayFillDetailService")
public class DayFillDetailServiceImpl extends BaseServiceImpl<DayFillDetailMapper, DayFillDetailEntity> implements IDayFillDetailService{

    @Override
    public void deleteDetailByProgressIds(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<DayFillDetailEntity>().in("progress_id", ids));
    }

    @Override
    public void deleteByProgressId(Long id) {
        baseMapper.delete(new QueryWrapper<DayFillDetailEntity>().eq("progress_id", id));
    }
}
