package com.ejianc.business.jlprogress.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlprogress.progress.bean.*;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.CommonHelper;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("totalPlanChange")
public class TotalPlanChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITotalPlanService service;
    @Autowired
    private ITotalPlanDetailService detailService;
    @Autowired
    private ITotalPlanChangeService changeService;
    @Autowired
    private ITotalPlanDetailChangeService detailChangeService;
    @Autowired
    private ITotalPlanHistoryService historyService;
    @Autowired
    private ITotalPlanDetailHistoryService detailHistoryService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //校验关联负责人
        List<TotalPlanDetailChangeEntity> detailList = detailChangeService.list(new QueryWrapper<TotalPlanDetailChangeEntity>().eq("progress_id", billId));
        commonHelper.validateEmployeeEntity(detailList);
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //校验关联负责人
        List<TotalPlanDetailChangeEntity> detailList1 = detailChangeService.list(new QueryWrapper<TotalPlanDetailChangeEntity>().eq("progress_id", billId));
        commonHelper.validateEmployeeEntity(detailList1);

        logger.info("--------------变更审批通过，处理业务");
        TotalPlanChangeEntity changeEntity = changeService.selectById(billId);
        QueryWrapper<TotalPlanDetailChangeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", billId);
        queryWrapper.orderByAsc("tid");
        List<TotalPlanDetailChangeEntity> detailChangeList = detailChangeService.list(queryWrapper);
        logger.info("--------------同步原始计划到记录表");
        TotalPlanEntity entity = service.selectById(changeEntity.getTotalId());
        QueryWrapper<TotalPlanDetailEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("progress_id", entity.getId());
        queryWrapper1.orderByAsc("tid");
        List<TotalPlanDetailEntity> detailList = detailService.list(queryWrapper1);
        Map<Long, TotalPlanDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(TotalPlanDetailEntity::getId, x->x));
        //List<Long> detailIds = detailList.stream().map(TotalPlanDetailEntity::getId).collect(Collectors.toList());
        List<Long> detailIds = new ArrayList<>();
        for (TotalPlanDetailEntity pde : detailList) {
            detailIds.add(pde.getId());
        }
        TotalPlanHistoryEntity historyEntity = BeanMapper.map(entity, TotalPlanHistoryEntity.class);
        Long historyId = IdWorker.getId();
        historyEntity.setTotalId(historyEntity.getId());
        historyEntity.setId(historyId);
        historyService.save(historyEntity);
        List<TotalPlanDetailHistoryEntity> historyDetailEntity = BeanMapper.mapList(detailList, TotalPlanDetailHistoryEntity.class);
        Map<Long, Long> pmap = new HashMap<>();
        for (TotalPlanDetailHistoryEntity pdh : historyDetailEntity) {
            Long historyDetailId = IdWorker.getId();
            pdh.setTotalId(entity.getId());
            pdh.setTotalBid(pdh.getId());
            pdh.setProgressId(historyId);
            pdh.setId(historyDetailId);
            pmap.put(pdh.getTotalBid(), pdh.getId());
        }
        for (TotalPlanDetailHistoryEntity pdh : historyDetailEntity) {
            pdh.setParentId(pmap.containsKey(pdh.getParentId()) ? pmap.get(pdh.getParentId()) : -1L);
            TreeUtils.resetProjectClomn(pdh, pmap);
        }
        detailHistoryService.saveBatch(historyDetailEntity);
        logger.info("--------------同步变更到原计划表");
        entity.setChangeStatus(PlanConstant.CHANGE_OVER);
        entity.setChangeVersion(changeEntity.getChangeVersion());
        entity.setChangeApprovedTime(new Date());
        entity.setChangeReason(changeEntity.getChangeReason());
        entity.setChangeDescription(changeEntity.getChangeDescription());
        // 日历变更需回写到原单据
        entity.setCalendarUid(changeEntity.getCalendarUid());
        entity.setCalendars(changeEntity.getCalendars());
        // 表头汇总时间变更需回写到原单据
        entity.setPlanBeginDate(changeEntity.getPlanBeginDate());
        entity.setPlanEndDate(changeEntity.getPlanEndDate());
        service.updateById(entity);
        List<TotalPlanDetailEntity> newDetail = new ArrayList<>();
        Map<Long, Long> idmap = new HashMap<>();
        for (TotalPlanDetailChangeEntity pdc : detailChangeList) {
            Long detailId = IdWorker.getId();
            if (pdc.getTotalBid() != null && pdc.getTotalBid() > 0) {
                idmap.put(pdc.getId(), pdc.getTotalBid());
                pdc.setId(pdc.getTotalBid());
                detailIds.remove(pdc.getTotalBid());
            } else {
                idmap.put(pdc.getId(), detailId);
                pdc.setId(detailId);
            }
            pdc.setProgressId(entity.getId());
            // version替换，否则更新不了
            if(detailMap.containsKey(pdc.getId())){
                pdc.setVersion(detailMap.get(pdc.getId()).getVersion());
            }
            newDetail.add(BeanMapper.map(pdc, TotalPlanDetailEntity.class));
        }
        if (detailIds != null && detailIds.size() > 0) {
            detailService.deleteDetailByIds(detailIds);
        }
        for (TotalPlanDetailEntity pde : newDetail) {
            pde.setParentId(idmap.containsKey(pde.getParentId()) ? idmap.get(pde.getParentId()) : -1L);
            TreeUtils.resetProjectClomn(pde, idmap);
        }
        detailService.saveOrUpdateBatch(newDetail, newDetail.size(), false);
        logger.info("--------------变更审批通过时间");
        LambdaUpdateWrapper<TotalPlanChangeEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(TotalPlanChangeEntity::getApprovedTime, new Date());
        lambd.eq(TotalPlanChangeEntity::getId, billId);
        changeService.update(lambd);
        logger.info("--------------处理变更附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(billId), PlanConstant.TOTAL_PLAN_CHANGE_BILL_TYPE, PlanConstant.TOTAL_PLAN_CHANGE_SOURCE_TYPE,
                String.valueOf(entity.getId()), PlanConstant.TOTAL_PLAN_BILL_TYPE, PlanConstant.TOTAL_PLAN_SOURCE_TYPE);
        execPlanService.pushExecPlan(entity.getId(), PlanConstant.TOTAL_PLAN);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
