package com.ejianc.business.jlprogress.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.quality.bean.SupplyConfirmDetailEntity;

/**
 * 质量检测-物资供货确认单-主表
 *
 * @author generator
 */
@TableName("ejc_quality_supply_confirm")
public class SupplyConfirmEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 确认单号
    @TableField(value = "confirm_date")
    private Date confirmDate; // 确认日期
    @TableField(value = "product_type")
    private Long productType; // 产品类型
    @TableField(value = "product_type_name")
    private Long productTypeName; // 产品类型名称
    @TableField(value = "org_id")
    private Long orgId; // 上报部门
    @TableField(value = "org_name")
    private String orgName; // 上报部门名称
    @TableField(value = "org_code")
    private String orgCode; // 上报部门编码
    @TableField(value = "supply_id")
    private String supplyId; // 供货单号
    @TableField(value = "supply_code")
    private String supplyCode; // 供货单号
    @TableField(value = "unit_id")
    private Long unitId; // 供货单位
    @TableField(value = "unit_name")
    private String unitName; // 供货单位名称
    @TableField(value = "purchase_id")
    private Long purchaseId; // 采购员
    @TableField(value = "purchase_name")
    private String purchaseName; // 采购员名称
    @TableField(value = "supply_date")
    private Date supplyDate; // 供货日期
    @TableField(value = "use_memo")
    private String useMemo; // 用途
    @TableField(value = "production_memo")
    private String productionMemo; // 生产厂商
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态


    @TableField(exist = false)
    @SubEntity(serviceName = "supplyConfirmDetailService", pidName = "confirmId")
    private List<SupplyConfirmDetailEntity> supplyConfirmDetailList = new ArrayList<>(); // 质量检测-物资供货确认单-子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }

    public Long getProductType() {
        return productType;
    }

    public void setProductType(Long productType) {
        this.productType = productType;
    }

    public Long getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(Long productTypeName) {
        this.productTypeName = productTypeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Date getSupplyDate() {
        return supplyDate;
    }

    public void setSupplyDate(Date supplyDate) {
        this.supplyDate = supplyDate;
    }

    public String getUseMemo() {
        return useMemo;
    }

    public void setUseMemo(String useMemo) {
        this.useMemo = useMemo;
    }

    public String getProductionMemo() {
        return productionMemo;
    }

    public void setProductionMemo(String productionMemo) {
        this.productionMemo = productionMemo;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<SupplyConfirmDetailEntity> getSupplyConfirmDetailList() {
        return supplyConfirmDetailList;
    }

    public void setSupplyConfirmDetailList(List<SupplyConfirmDetailEntity> supplyConfirmDetailList) {
        this.supplyConfirmDetailList = supplyConfirmDetailList;
    }

    public String getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(String supplyId) {
        this.supplyId = supplyId;
    }
}
