package com.ejianc.business.jlprogress.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.PurchaseFeedbackMapper;
import com.ejianc.business.jlprogress.quality.bean.PurchaseFeedbackEntity;
import com.ejianc.business.jlprogress.quality.service.IPurchaseFeedbackService;

/**
 * 质量检测-进货质量反馈单
 * 
 * @author generator
 * 
 */
@Service("purchaseFeedbackService")
public class PurchaseFeedbackServiceImpl extends BaseServiceImpl<PurchaseFeedbackMapper, PurchaseFeedbackEntity> implements IPurchaseFeedbackService{



    @Override
    public Boolean CheckBillCodeIsExist(PurchaseFeedbackEntity purchaseFeedbackEntity) {
        LambdaQueryWrapper<PurchaseFeedbackEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PurchaseFeedbackEntity::getBillCode, purchaseFeedbackEntity.getBillCode());
        if (purchaseFeedbackEntity.getId() != null) {
            wrapper.ne(PurchaseFeedbackEntity::getId, purchaseFeedbackEntity.getId());
        }
        PurchaseFeedbackEntity purchaseFeedback = this.getOne(wrapper);
        return purchaseFeedback != null;
    }
}
