package com.ejianc.business.jlprogress.labor.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.jlprogress.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlprogress.labor.bean.WorkRecordEntity;

import java.text.ParseException;
import java.util.List;

/**
 * 劳务实名制-用工记录
 * 
 * @author generator
 * 
 */
public interface IWorkRecordService extends IBaseService<WorkRecordEntity> {
    /**
     * 公司推送 设置
     *      teamId teamName orgTeamId orgTeamName
     *      workType workTypeName orgWorkType  orgWorkTypeName
     *      TeamInnerCode orgTeamInnerCode
     * 项目推送 设置
     *      teamId teamName projectTeamId projectTeamName
     *      workType workTypeName projectWorkType projectWorkTypeName
     *      TeamInnerCode projectTeamInnerCode
     * 设置来源 sourceFlag 来源（1自制-劳务进场单、2公司花名册、3邀请）
     * @param voList
     * @return
     */
    List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList);

    WorkRecordVO updateWorkRecord(WorkRecordVO vo);
    WorkRecordVO updateBatWorker(WorkRecordVO updateVO);


    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId);

    CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(
            int pageNumber,
            int pageSize,
            String relyCondition,
            String searchText,
            String condition,
            String searchObject) throws ParseException;
}
