package com.ejianc.business.jlprogress.order.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.QueryChainWrapper;
import com.ejianc.business.jlprogress.order.bean.PriceDetailEntity;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.service.IPriceDetailService;
import com.ejianc.business.jlprogress.order.service.IPriceService;
import com.ejianc.business.jlprogress.order.service.impl.PriceServiceImpl;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.order.vo.PriceDetailVO;
import com.ejianc.business.jlprogress.order.vo.PriceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;
import com.ejianc.business.jlprogress.order.vo.OutStoreVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 订单及运单-材料出库单-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outStore")
public class OutStoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IPriceService priceService;
    @Autowired
    private IPriceDetailService priceDetailService;


    private static final String BILL_CODE = "OUT_STORE";//此处需要根据实际修改

    @Autowired
    private IOutStoreService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO saveOrUpdateVO) {
        OutStoreEntity entity = BeanMapper.map(saveOrUpdateVO,OutStoreEntity.class);
        //查询是否存在编号相同的单据
        LambdaQueryWrapper<OutStoreEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OutStoreEntity::getBillCode,saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(OutStoreEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(OutStoreEntity::getId,saveOrUpdateVO.getId());
        }
        List<OutStoreEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw  new BusinessException("当前编码已经使用！");
        }

        //if(entity.getId() == null || entity.getId() == 0){
        //    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
        //    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        //    if(billCode.isSuccess()) {
        //        //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        //        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        //    }else{
        //        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        //    }
        //}
        //设置组织
        //entity.setOrgId(InvocationInfoProxy.getOrgId());
    	service.saveOrUpdate(entity, false);
    	OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
    	OutStoreEntity entity = service.selectById(id);
    	OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutStoreVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeOrgName");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeEmployeeName");
        fuzzyFields.add("store_date");
        fuzzyFields.add("storeMny");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        //UserContext userContextCache =sessionManager.getUserContext();
        ////当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        //String authOrgIds = userContextCache.getAuthOrgIds();
        //List<OrgVO> orgVOList = null;
        //if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
        //    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        //}else {//pc端查询
        //    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //}
        ////普通组织 id
        //List<Long> commonOrgIds = new ArrayList<>();
        ////项目部 id
        //List<Long> departmentIds = new ArrayList<>();
        //orgVOList.stream().forEach(org -> {
        //    if(5 == org.getOrgType()) {
        //        //项目部
        //        departmentIds.add(org.getId());
        //    } else {
        //        //普通组织
        //        commonOrgIds.add(org.getId());
        //    }
        //});
        //if(CollectionUtils.isNotEmpty(commonOrgIds)) {
        //    /** 要求主表有orgId字段，保存单据所属组织 */
        //    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        //} else if(CollectionUtils.isNotEmpty(departmentIds)) {
        //    /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
        //    param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        //}
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeOrgName");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("storeEmployeeName");
        fuzzyFields.add("store_date");
        fuzzyFields.add("storeMny");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutStoreEntity> list = service.queryList(param);
        //todo:字段翻译等等
        for (OutStoreEntity outStore:list){
            switch (outStore.getBillState()){
                case 0:outStore.setBillStateName("自由态"); break;
                case 1:outStore.setBillStateName("已提交"); break;
                case 2:outStore.setBillStateName("审批中"); break;
                case 3:outStore.setBillStateName("审批通过"); break;
                case 4:outStore.setBillStateName("审批驳回"); break;
                case 5:outStore.setBillStateName("审批中"); break;
                case 6:outStore.setBillStateName("审批驳回"); break;
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutStoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "OutStoreDetail-import.xlsx", "材料出库-物料明细模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<OutStoreDetailVO> successList = new ArrayList<>();
        List<OutStoreDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                List<Long> materialIdList = new ArrayList<>();
                Map<String,MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes =  iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
                if(!materialRes.isSuccess()){
                    return CommonResponse.error(materialRes.getMsg());
                }

                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));

                //处理单价
                materialIdList = materialRes.getData().stream().map(MaterialVO::getId).collect(Collectors.toList());
                Long storeOrgId = Long.valueOf(request.getParameter("storeOrgId"));
                Long storeId = Long.valueOf(request.getParameter("storeId"));
                logger.info("storeOrgId: {} ,storeId: {}, storeData: {}",storeOrgId,storeId,request.getParameter("storeDate"));
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date storeData = ft.parse(request.getParameter("storeDate"));
                Map<Long,PriceDetailVO> priceMap = new HashMap<>();

                CommonResponse<List<PriceDetailVO>> listCommonResponse = queryPrice(materialIdList, storeOrgId, storeId, storeData);
                if (!listCommonResponse.isSuccess()){
                    return CommonResponse.error(listCommonResponse.getMsg());
                }
                if(ObjectUtils.isNotEmpty(listCommonResponse.getData())){
                    priceMap = listCommonResponse.getData().stream().collect(Collectors.toMap(p -> p.getMaterialId(),Function.identity()));
                }
                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OutStoreDetailVO detailVO = new OutStoreDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());

                    //材料code  材料Id赋值
                    try {
                        String materialCode = datas.get(0);
                        detailVO.setMaterialCode(materialCode);
                        if (ObjectUtils.isEmpty(map.get(materialCode))){
                            throw new Exception("没有此材料！");
                        }

                        detailVO.setMaterialId(map.get(materialCode).getId());
                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                        detailVO.setUnit(map.get(materialCode).getUnitName());
                        detailVO.setMaterialTypeId(map.get(materialCode).getCategoryId());
                        detailVO.setMaterialTypeCode(map.get(materialCode).getCategoryCode());
                        detailVO.setMaterialTypeName(map.get(materialCode).getCategoryName());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //给辐单位赋值
                    String assistUnit = datas.get(4);
                    detailVO.setAssistUnit(assistUnit);

                    //实发主数量  校验赋值
                    try {
                        String materialNum = datas.get(5);
                        detailVO.setMaterialNum(StringUtils.isNotBlank(materialNum)?new BigDecimal(materialNum):null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("实发主数量错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //实发数量  校验赋值
                    try {
                        String materialAssistNum = datas.get(6);
                        detailVO.setMaterialAssistNum(StringUtils.isNotBlank(materialAssistNum) ? new BigDecimal(materialAssistNum) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("实发数量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //TODO 出库单价  校验赋值
                    if (ObjectUtils.isNotEmpty(priceMap.get(detailVO.getMaterialId()))){
                        detailVO.setDetailStorePrice( priceMap.get(detailVO.getMaterialId()).getMaterialPrice());
                    }

                    //BigDecimal detailStorePrice = new BigDecimal();
                    //try {
                    //
                    //    detailVO.setDetailStorePrice( new BigDecimal(detailStorePrice));
                    //}
                    //catch (Exception e) {
                    //    detailVO.setErrorMsg("出库单价错误！");
                    //    errorList.add(detailVO);
                    //    continue;
                    //}

                    //TODO 金额  校验赋值
                    if (ObjectUtils.isNotEmpty(detailVO.getDetailStorePrice())&&ObjectUtils.isNotEmpty(detailVO.getMaterialNum())){
                        detailVO.setDetailStoreMny( priceMap.get(detailVO.getMaterialId()).getMaterialPrice().multiply(detailVO.getMaterialNum()));
                    }
//                    try {
////                        String detailStoreMny = datas.get(5);
//                        if(StringUtils.isBlank(datas.get(5))||new BigDecimal(detailStorePrice))
//                        detailVO.setDetailStoreMny(new BigDecimal(datas.get(2)).multiply(new BigDecimal(datas.get(4))));
//                    }
//                    catch (Exception e) {
//                        detailVO.setErrorMsg("金额计算错误！");
//                        errorList.add(detailVO);
//                        continue;

//                    }

                    //金额 校验  --- excel改了
//                    try {
//                        BigDecimal detailSum =new BigDecimal(datas.get(2)).multiply(new BigDecimal(datas.get(4)));
//                        if (detailSum.compareTo(new BigDecimal(datas.get(5)))!=0){
//                            throw new Exception("金额计算错误！");
//                        }
//                    }
//                    catch (Exception e) {
//                        detailVO.setErrorMsg("金额计算错误！");
//                        errorList.add(detailVO);
//                        continue;
//                    }
//                    //给备注值
//                    String memo = datas.get(6);
//                    detailVO.setMemo(memo);
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 查询单价信息
     * @param materialIds
     * @param storeOrgId
     * @param storeId
     */
    @RequestMapping(value = "/queryPrice")
    @ResponseBody
    public CommonResponse<List<PriceDetailVO>> queryPrice(@RequestParam List<Long> materialIds, Long storeOrgId, Long storeId,Date storeDate) {

        if(storeOrgId!=null){
            //获取价格主表Id
            QueryParam param = new QueryParam();
            param.getParams().put("orgId",new Parameter(QueryParam.EQ,storeOrgId));
            Instant instant=storeDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate date = instant.atZone(zoneId).toLocalDate();
            logger.info("日期"+ date.with(TemporalAdjusters.firstDayOfMonth()));
            param.getParams().put("month",new Parameter(QueryParam.EQ, date.with(TemporalAdjusters.firstDayOfMonth())));
            List<Integer> state = new ArrayList<>();
            state.add(1);
            state.add(3);
            param.getParams().put("billState",new Parameter(QueryParam.IN, state));
            param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
            List<PriceEntity> priceEntities = priceService.queryList(param);
            if(ObjectUtils.isEmpty(priceEntities)){
                //获取上个月日期
                param.getParams().put("month",new Parameter(QueryParam.EQ, date.minusMonths(1).with(TemporalAdjusters.firstDayOfMonth())));
                priceEntities = priceService.queryList(param);
                if (ObjectUtils.isEmpty(priceEntities)){
                    return CommonResponse.success("没有价格");
                }
            }
            List<Long> ids = priceEntities.stream().map(PriceEntity::getId).collect(Collectors.toList());
            //获取价格
            QueryParam param1 = new QueryParam();
            param1.getParams().put("priceId",new Parameter(QueryParam.IN,ids));
            param1.getParams().put("storeId",new Parameter(QueryParam.EQ,storeId));
            param1.getParams().put("materialId",new Parameter(QueryParam.IN,materialIds));
            List<PriceDetailEntity> priceDetailEntities = priceDetailService.queryList(param1);
            if (ObjectUtils.isEmpty(priceDetailEntities)){
                return CommonResponse.success("没有价格");
            }
            List<PriceDetailVO> entity = BeanMapper.mapList(priceDetailEntities, PriceDetailVO.class);
            return CommonResponse.success(entity);
        }
        return null;
    }
}
