package com.ejianc.business.jlprogress.progress.bean;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jlprogress.progress.vo.DayFillDetailVO;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 日进度计划填报详情
 *
 * @author generator
 */
@TableName("ejc_zjkjprogress_day_fill_detail")
public class DayFillDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value = "node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value = "plan_start")
    private Date planStart; // 计划开始日期
    @TableField(value = "plan_finish")
    private Date planFinish; // 计划完成日期
    @TableField(value = "estimate_finish")
    private Date estimateFinish; // 预计完成日期
    @TableField(value = "employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value = "employee_name")
    private String employeeName; // 负责人名称
    @TableField(value = "plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value = "finish_num")
    private BigDecimal finishNum; // 完成工程量
    @TableField(value = "unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value = "diff_value")
    private BigDecimal diffValue; // 偏差时间
    @TableField(value = "diff_type")
    private Long diffType; // 偏差原因类型
    @TableField(value = "diff_resson")
    private String diffResson; // 偏差原因
    @TableField(value = "resource_name")
    private String resourceName; // 资源名称
    @TableField(value = "type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value = "type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value = "need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value = "resource_num")
    private BigDecimal resourceNum; // 实际资源量
    @TableField(value = "diff_num")
    private BigDecimal diffNum; // 资源偏差
    @TableField(value = "start_source_type")
    private Integer startSourceType;
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级(0-否，1-是)
    @TableField(value = "plan_duration")
    private Integer planDuration;// 计划工期
    @TableField(value="predict_start")
    private Date predictStart; // 预测开始日期
    @TableField(value="show_state")
    private Boolean showState; // 显隐标识 0-隐藏 1-显示
    @TableField(value = "plan_pre_link")
    private String planPreLink; // 计划前置任务
    @TableField(value = "old_pre_link")
    private String oldPreLink; // 历史前置任务
    @TableField(value = "this_num")
    private BigDecimal thisNum; // 本期完成量
    @TableField(value = "last_finish_num")
    private BigDecimal lastFinishNum; // 截止上期完工量


    public BigDecimal getThisNum() {
        return thisNum;
    }

    public void setThisNum(BigDecimal thisNum) {
        this.thisNum = thisNum;
    }

    public BigDecimal getLastFinishNum() {
        return lastFinishNum;
    }

    public void setLastFinishNum(BigDecimal lastFinishNum) {
        this.lastFinishNum = lastFinishNum;
    }

    public String getOldPreLink() {
        return oldPreLink;
    }

    public void setOldPreLink(String oldPreLink) {
        this.oldPreLink = oldPreLink;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Integer getStartSourceType() {
        return startSourceType;
    }

    public void setStartSourceType(Integer startSourceType) {
        this.startSourceType = startSourceType;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }

    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }

    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }

    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }

    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }

    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }

    public Integer getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(Integer planDuration) {
        this.planDuration = planDuration;
    }

    public Date getPredictStart() {
        return predictStart;
    }

    public void setPredictStart(Date predictStart) {
        this.predictStart = predictStart;
    }

    public Boolean getShowState() {
        return showState;
    }

    public void setShowState(Boolean showState) {
        this.showState = showState;
    }

    public String getPlanPreLink() {
        return planPreLink;
    }

    public void setPlanPreLink(String planPreLink) {
        this.planPreLink = planPreLink;
    }

    /**
     * entity to vo
     */
    public static DayFillDetailVO convertEntityToVo(DayFillDetailEntity entity) {
        DayFillDetailVO progressDetailVo = new DayFillDetailVO();
        progressDetailVo.setUid(entity.getId().toString());
        progressDetailVo.setManual(entity.getManual());
        progressDetailVo.setActualDuration(entity.getActualDuration());
        progressDetailVo.setDuration(entity.getDuration());
        progressDetailVo.setPercentComplete(entity.getPercentComplete());
        progressDetailVo.setDepartment(entity.getDepartment());
        progressDetailVo.setProjectUID(entity.getProjectId());
        progressDetailVo.setMilestone(entity.getMilestone());
        progressDetailVo.setFinish(entity.getFinish());
        progressDetailVo.setConstraintType(entity.getConstraintType());
        progressDetailVo.setPrincipal(entity.getPrincipal());
        progressDetailVo.setParentTaskUID(entity.getParentId() + "");
        progressDetailVo.setWbs(entity.getWbs());
        if (StringUtils.isNotBlank(entity.getAssignments())) {
            progressDetailVo.setAssignments(JSON.parseArray(entity.getAssignments()));
        }
        progressDetailVo.setStart(entity.getStart());
        progressDetailVo.setOutlineLevel(entity.getOutlineLevel());
        progressDetailVo.setOutlineNumber(entity.getOutlineNumber());
        progressDetailVo.setCritical(entity.getCritical());
        progressDetailVo.setNote(entity.getNotes());
        progressDetailVo.setSummary(entity.getSummary());
        progressDetailVo.setActualFinish(entity.getActualFinish());
        progressDetailVo.setName(entity.getName());
        progressDetailVo.setId(entity.getTid());
        progressDetailVo.setCode(entity.getCode());
        progressDetailVo.setStructCode(entity.getStructCode());
        progressDetailVo.setWeight(entity.getWeight());
        progressDetailVo.setFixedDate(entity.getFixedDate());
        progressDetailVo.setWork(entity.getWork());
        progressDetailVo.setConstraintDate(entity.getConstraintDate());
        if(StringUtils.isNotBlank(entity.getPredecessorLink())) {
            progressDetailVo.setPredecessorLink(JSON.parseArray(entity.getPredecessorLink()));
        }
        if(StringUtils.isNotBlank(entity.getOldPreLink())) {
            progressDetailVo.setOldPreLink(JSON.parseArray(entity.getOldPreLink()));
        }
        progressDetailVo.setPriority(entity.getPriority());
        progressDetailVo.setActualStart(entity.getActualStart());

        progressDetailVo.setTaskLine(entity.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailVo.setNodeLevel(entity.getNodeLevel()); // 节点级别
        progressDetailVo.setEmployeeId(entity.getEmployeeId()); // 负责人主键
        progressDetailVo.setEmployeeName(entity.getEmployeeName()); // 负责人名称
        progressDetailVo.setPlanNum(entity.getPlanNum()); // 工程量
        progressDetailVo.setUnit(entity.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailVo.setResourceName(entity.getResourceName()); // 资源名称
        progressDetailVo.setType(entity.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailVo.setTypeUnit(entity.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailVo.setNeedNum(entity.getNeedNum()); // 需求量

        progressDetailVo.setPlanStart(entity.getPlanStart());
        progressDetailVo.setPlanFinish(entity.getPlanFinish());
        progressDetailVo.setEstimateFinish(entity.getEstimateFinish());
        progressDetailVo.setFinishNum(entity.getFinishNum());
        progressDetailVo.setDiffValue(entity.getDiffValue());
        progressDetailVo.setDiffType(entity.getDiffType());
        progressDetailVo.setDiffResson(entity.getDiffResson());
        progressDetailVo.setDiffNum(entity.getDiffNum());
        progressDetailVo.setResourceNum(entity.getResourceNum());
        progressDetailVo.setStartSourceType(entity.getStartSourceType());
        progressDetailVo.setLeafFlag(entity.getLeafFlag());
        progressDetailVo.setPlanDuration(entity.getPlanDuration());
        progressDetailVo.setPredictStart(entity.getPredictStart());
        progressDetailVo.setShowState(entity.getShowState());
        progressDetailVo.setPlanPreLink(entity.getPlanPreLink());
        progressDetailVo.setThisNum(entity.getThisNum());
        progressDetailVo.setLastFinishNum(entity.getLastFinishNum());
        progressDetailVo.setWbsParent(entity.getWbsParent());
        progressDetailVo.setUnitName(entity.getUnitName());
        return progressDetailVo;
    }

    /**
     * vo to entity
     */
    public static DayFillDetailEntity convertVoToEntity(DayFillDetailVO vo) {
        DayFillDetailEntity progressDetailEntity = new DayFillDetailEntity();
        if(StringUtils.isNotBlank(vo.getUid())) {
            progressDetailEntity.setId(Long.parseLong(vo.getUid()));
        }
        progressDetailEntity.setManual(vo.getManual());
        progressDetailEntity.setActualDuration(vo.getActualDuration());
        progressDetailEntity.setDuration(vo.getDuration());
        progressDetailEntity.setPercentComplete(vo.getPercentComplete());
        progressDetailEntity.setDepartment(vo.getDepartment());
        progressDetailEntity.setProjectId(vo.getProjectUID());
        progressDetailEntity.setMilestone(vo.getMilestone());
        progressDetailEntity.setFinish(vo.getFinish());
        progressDetailEntity.setConstraintType(vo.getConstraintType());
        progressDetailEntity.setPrincipal(vo.getPrincipal());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            progressDetailEntity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        progressDetailEntity.setWbs(vo.getWbs());
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            progressDetailEntity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        progressDetailEntity.setStart(vo.getStart());
        progressDetailEntity.setOutlineLevel(vo.getOutlineLevel());
        progressDetailEntity.setOutlineNumber(vo.getOutlineNumber());
        progressDetailEntity.setCritical(vo.getCritical());
        progressDetailEntity.setNotes(vo.getNote());
        progressDetailEntity.setSummary(vo.getSummary());
        progressDetailEntity.setActualFinish(vo.getActualFinish());
        progressDetailEntity.setName(vo.getName());
        progressDetailEntity.setTid(vo.getId());
        progressDetailEntity.setCode(vo.getCode());
        progressDetailEntity.setStructCode(vo.getStructCode());
        progressDetailEntity.setWeight(vo.getWeight());
        progressDetailEntity.setFixedDate(vo.getFixedDate());
        progressDetailEntity.setWork(vo.getWork());
        progressDetailEntity.setConstraintDate(vo.getConstraintDate());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            progressDetailEntity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        if(vo.getOldPreLink() != null && vo.getOldPreLink().size() > 0) {
            progressDetailEntity.setOldPreLink(JSON.toJSONString(vo.getOldPreLink()));
        }
        progressDetailEntity.setPriority(vo.getPriority());
        progressDetailEntity.setActualStart(vo.getActualStart());

        progressDetailEntity.setTaskLine(vo.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailEntity.setNodeLevel(vo.getNodeLevel()); // 节点级别
        progressDetailEntity.setEmployeeId(vo.getEmployeeId()); // 负责人主键
        progressDetailEntity.setEmployeeName(vo.getEmployeeName()); // 负责人名称
        progressDetailEntity.setPlanNum(vo.getPlanNum()); // 工程量
        progressDetailEntity.setUnit(vo.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailEntity.setResourceName(vo.getResourceName()); // 资源名称
        progressDetailEntity.setType(vo.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailEntity.setTypeUnit(vo.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailEntity.setNeedNum(vo.getNeedNum()); // 需求量

        progressDetailEntity.setPlanStart(vo.getPlanStart());
        progressDetailEntity.setPlanFinish(vo.getPlanFinish());
        progressDetailEntity.setEstimateFinish(vo.getEstimateFinish());
        progressDetailEntity.setFinishNum(vo.getFinishNum());
        progressDetailEntity.setDiffValue(vo.getDiffValue());
        progressDetailEntity.setDiffType(vo.getDiffType());
        progressDetailEntity.setDiffResson(vo.getDiffResson());
        progressDetailEntity.setDiffNum(vo.getDiffNum());
        progressDetailEntity.setResourceNum(vo.getResourceNum());
        progressDetailEntity.setStartSourceType(vo.getStartSourceType());
        progressDetailEntity.setLeafFlag(vo.getLeafFlag());
        progressDetailEntity.setPlanDuration(vo.getPlanDuration());
        progressDetailEntity.setPredictStart(vo.getPredictStart());
        progressDetailEntity.setShowState(vo.getShowState());
        progressDetailEntity.setPlanPreLink(vo.getPlanPreLink());
        progressDetailEntity.setThisNum(vo.getThisNum());
        progressDetailEntity.setLastFinishNum(vo.getLastFinishNum());
        progressDetailEntity.setWbsParent(vo.getWbsParent());
        progressDetailEntity.setUnitName(vo.getUnitName());
        return progressDetailEntity;
    }
}
