package com.ejianc.business.jlprogress.progress.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.cons.FillConstant;
import com.ejianc.business.jlprogress.progress.mapper.DayFillDetailMapper;
import com.ejianc.business.jlprogress.progress.mapper.DayFillMapper;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.utils.PageUtil;
import com.ejianc.business.jlprogress.progress.utils.WarnFeignUtil;
import com.ejianc.business.jlprogress.progress.vo.DayFillDetailVO;
import com.ejianc.business.jlprogress.progress.vo.DayFillVO;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.handler.DurationUtil;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.utils.OrgUtil;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.enums.DefDocIdEnum;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 日进度计划填报
 *
 * @author generator
 */
@Service("dayFillService")
public class DayFillServiceImpl extends BaseServiceImpl<DayFillMapper, DayFillEntity> implements IDayFillService {

    private static final String BILL_CODE = "ZJKJ_DAY_FILL";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DayFillMapper dayFillMapper;
    @Autowired
    private DayFillDetailMapper dayFillDetailMapper;
    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    private final static List<Long> diffTypes = new ArrayList<>(Arrays.asList(1607284873290158082L, 1607284911340883970L,
            1607285065540276225L, 1607285101045059585L, 1607285151582228482L, 1607285189104472066L, 1607285573499850754L));

    @Override
    public CommonResponse<DayFillVO> saveOrUpdate(DayFillVO saveOrUpdateVO) {
//        LambdaQueryWrapper<DayFillEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(DayFillEntity::getProjectId, saveOrUpdateVO.getProjectId());
//        queryWrapper.eq(DayFillEntity::getFillUserId, saveOrUpdateVO.getFillUserId());
//        queryWrapper.notIn(DayFillEntity::getBillState, 1, 3);
//        queryWrapper.ne(null != saveOrUpdateVO.getId(), DayFillEntity::getId, saveOrUpdateVO.getId());
//        List<DayFillEntity> list = list(queryWrapper);
//        if (CollectionUtils.isNotEmpty(list)) {
//            throw new BusinessException("存在未生效单据，不允许新增");
//        }
        // 未生效单据校验
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId(), saveOrUpdateVO.getFillUserId());

        LambdaQueryWrapper<DayFillEntity> queryWrapper2 = new LambdaQueryWrapper<>();
        queryWrapper2.eq(DayFillEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, saveOrUpdateVO.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, 1, 3);
        queryWrapper2.ne(null != saveOrUpdateVO.getId(), DayFillEntity::getId, saveOrUpdateVO.getId());
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List<DayFillEntity> list2 = list(queryWrapper2);
        if (CollectionUtils.isNotEmpty(list2)) {
            if (saveOrUpdateVO.getFillDate().getTime() <= list2.get(0).getFillDate().getTime()) {
                throw new BusinessException("填报日期不能小于往期填报日期");
            }
        }
        List<DayFillDetailVO> tasks = saveOrUpdateVO.getTasks();
        List<DayFillDetailVO> detailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(tasks)){
            Map<String, Long> pkMap = new HashMap<>();
            TreeHelper2.tree2List(pkMap, detailList, tasks, saveOrUpdateVO.getImportFlag());
            // 重设历史前置任务
            this.resetOldPreLink(detailList, pkMap);
        }
//        // 校验数据合法性
//        this.validateDetailList(saveOrUpdateVO, detailList);

//        // 同步偏差原因及校验
//        this.syncDiffType(detailList, saveOrUpdateVO.getProjectId());

        Long tenantId = InvocationInfoProxy.getTenantid();
        DayFillEntity progressEntity = null;
        saveOrUpdateVO.setFinishFlag(DateUtil.getBetweenDays(saveOrUpdateVO.getFillDate(), new Date()) + 1);
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            saveOrUpdateVO.setUpdateUserId(sessionManager.getUserContext().getUserId());
            saveOrUpdateVO.setUpdateUserName(sessionManager.getUserContext().getUserName());
            saveOrUpdateVO.setUpdateDate(new Date());
            progressEntity = BeanMapper.map(saveOrUpdateVO, DayFillEntity.class);
            dayFillMapper.updateById(progressEntity);

            //子表
//            List<DayFillDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
//            if (progressDetailList.size() > 0) {
//                Map<String, Long> pkMap = new HashMap<>();
//                List<DayFillDetailVO> saveVOList = new ArrayList<>();
//                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
            if (detailList.size() > 0) {
                if (saveOrUpdateVO.getImportFlag()) {
                    detailService.deleteByProgressId(progressEntity.getId());
                }
                List<DayFillDetailEntity> saveList = new ArrayList<>();
                List<DayFillDetailEntity> updateList = new ArrayList<>();
                for (DayFillDetailVO progressDetailVo : detailList) {
                    progressDetailVo.setPredictStart(DateUtil.setHours(progressDetailVo.getPredictStart(), 8));
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        DayFillDetailEntity progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        // 默认开始时间早上8点，结束时间下午5点
                        progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                        progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                        progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                        progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                        progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                        progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                        saveList.add(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        DayFillDetailEntity progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        // 默认开始时间早上8点，结束时间下午5点
                        progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                        progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                        progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                        progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                        progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                        progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                        updateList.add(progressDetailEntity);
                    }
                }
                if (saveList.size() > 0) {
                    detailService.saveBatch(saveList);
                }
                if (updateList.size() > 0) {
                    detailService.updateBatchById(updateList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            //子表删除
            List<DayFillDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (DayFillDetailVO progressDetailVo : delDetailList) {
                    dayFillDetailMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            progressEntity = BeanMapper.map(saveOrUpdateVO, DayFillEntity.class);
            progressEntity.setId(masterPkId);
            dayFillMapper.insert(progressEntity);

            //子表
//            List<DayFillDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
//
//            if (progressDetailList.size() > 0) {
//                Map<String, Long> pkMap = new HashMap<>();
//                List<DayFillDetailVO> saveVOList = new ArrayList<DayFillDetailVO>();
//                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
            if (detailList.size() > 0) {
                List<DayFillDetailEntity> saveList = new ArrayList<>();
                for (DayFillDetailVO progressDetailVo : detailList) {
                    DayFillDetailEntity progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    // 默认开始时间早上8点，结束时间下午5点
                    progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                    progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                    progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                    progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                    progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                    progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                    saveList.add(progressDetailEntity);
                }
                detailService.saveBatch(saveList);
            } else {
                throw new BusinessException("计划详情不能为空");
            }

        }
        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    /**
     * 校验数据合法性
     * @param saveOrUpdateVO
     * @param detailList
     */
    private void validateDetailList(DayFillVO saveOrUpdateVO, List<DayFillDetailVO> detailList) {
        // 校验填写任务中末级是否存在“实际开始时间”有值，“完成百分比”为空的数据
        List<String> errorList = new ArrayList<>();
        List<String> actualList = new ArrayList<>();// 校验完成百分比为100，但是实际完成日期为空的数据
        List<String> percentList = new ArrayList<>();// 根据预计完成时间计算完成百分比是否与前端一致
        Date fillDate = saveOrUpdateVO.getFillDate();
        JSONObject calender = DurationUtil.getCalender(saveOrUpdateVO.getCalendars(), saveOrUpdateVO.getCalendarUid());
        if(CollectionUtils.isNotEmpty(detailList)){
            for (DayFillDetailVO vo : detailList) {
                if(vo.getShowState() && vo.getLeafFlag() && StringUtils.isNotEmpty(vo.getName())){
                    if(vo.getActualStart() != null && (vo.getPercentComplete() == null || vo.getPercentComplete() == 0)){
                        errorList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                    }
                    if(vo.getPercentComplete() != null && vo.getPercentComplete() == 100 && vo.getActualFinish() == null){
                        actualList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                    }
                    if(vo.getPercentComplete() != null && vo.getPercentComplete() != 0){
                        // 根据时间计算完成百分比
                        BigDecimal percentComplete = this.calculatePercentComplete(fillDate, vo, calender);
//                        // 预测完成时间 =（数据填写时间-实际开始时间+1）/完成百分比+实际开始时间
//                        BigDecimal duration = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.toBigDecimal(DateUtil.getSubDay(fillDate, vo.getActualStart())),
//                                ComputeUtil.toBigDecimal(vo.getPercentComplete())), new BigDecimal("100")).setScale(0, BigDecimal.ROUND_HALF_UP);
                        // 工期 = (填报时间-实际开始日期) + 计划工期 *（1-完成百分比）
                        BigDecimal duration = ComputeUtil.safeAdd(ComputeUtil.toBigDecimal(
                                DurationUtil.calculateDuration(vo.getActualStart(), fillDate, calender)),
                                ComputeUtil.safeMultiply(ComputeUtil.toBigDecimal(vo.getPlanDuration()), ComputeUtil.safeSub(BigDecimal.ONE,
                                ComputeUtil.safeDiv(ComputeUtil.toBigDecimal(vo.getPercentComplete()), new BigDecimal("100"))))
                        ).setScale(0, BigDecimal.ROUND_HALF_UP);
                        // 完成百分比和工期均不相等时，说明前端未触发编辑后事件
                        if(!vo.getPercentComplete().equals(percentComplete.intValue()) && !vo.getDuration().equals(duration.intValue())){
                            percentList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                        }
                    }
                }
                if(vo.getActualFinish() != null && DateUtil.compareDay(vo.getActualFinish(), vo.getFinish()) != 0){
                    throw new BusinessException(vo.getOutlineNumber() + "[" + vo.getName() + "]预测完成日期不等于实际完成日期，请联系系统管理员！");
                }
            }
        }
        if(CollectionUtils.isNotEmpty(errorList)){
            throw new BusinessException("保存失败！任务开始后（即[实际开始日期]有值），[完成百分比]必须大于0，以下任务不满足校验条件：" + StringUtils.join(errorList, ","));
        }
        if(CollectionUtils.isNotEmpty(actualList)){
            throw new BusinessException("保存失败！任务已完成（即实际开始日期]有值，[完成百分比]等于100），[实际完成日期]不允许为空，以下任务不满足校验条件：" + StringUtils.join(actualList, ","));
        }
        if(CollectionUtils.isNotEmpty(percentList)){
            throw new BusinessException("保存失败！根据预计完成时间计算完成百分比应该一致，以下任务不满足校验条件：" + StringUtils.join(percentList, ","));
        }
    }

    /**
     * 重设历史前置任务
     * @param detailList
     * @param pkMap
     */
    private void resetOldPreLink(List<DayFillDetailVO> detailList, Map<String, Long> pkMap) {
        for (int i = 0, len = detailList.size(); i < len; i++) {
            DayFillDetailVO vo = detailList.get(i);
            if (vo.getOldPreLink() != null && vo.getOldPreLink().size() > 0) {
                for (int j = 0; j < vo.getOldPreLink().size(); j++) {
                    JSONObject predecessorLinkObj = vo.getOldPreLink().getJSONObject(j);
                    String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
                    if (pkMap.containsKey(PredecessorUID)) {
                        predecessorLinkObj.put("PredecessorUID", pkMap.get(PredecessorUID));
                    }
                    String TaskUID = predecessorLinkObj.getString("TaskUID");
                    if (pkMap.containsKey(TaskUID)) {
                        predecessorLinkObj.put("TaskUID", pkMap.get(TaskUID));
                    }
                }
            }
        }
    }

    /**
     * 1、偏差大于0，校验偏差原因类型必输；
     * 2、偏差小于等于0，或者已完成的任务，清空偏差原因类型、偏差原因
     * 3、如果该任务是第一次上报，没有历史数据，则查找前置任务的“偏差原因类型”和“偏差原因”，并带入
     * @param detailList
     */
    private void syncDiffType(List<DayFillDetailVO> detailList, Long projectId) {
        if(CollectionUtils.isEmpty(detailList)) {
            return;
        }
        ExecPlanEntity exec = execPlanService.getOne(new QueryWrapper<ExecPlanEntity>().eq("project_id", projectId));
        List<ExecPlanDetailEntity> execDetailList = execPlanDetailService.list(new QueryWrapper<ExecPlanDetailEntity>()
                .eq("progress_id", exec.getId()).orderByAsc("tid"));
        Map<String, ExecPlanDetailEntity> codeMap = execDetailList.stream().collect(Collectors.toMap(ExecPlanDetailEntity::getStructCode, x->x));
        Map<Long, ExecPlanDetailEntity> idMap = execDetailList.stream().collect(Collectors.toMap(ExecPlanDetailEntity::getId, x->x));
        Map<String, DayFillDetailVO> detailMap = detailList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x, (v1, v2)->v2));
        for (DayFillDetailVO vo : detailList) {
            // 只有显示和末级的才处理偏差原因
            if(!vo.getShowState() && !vo.getLeafFlag()){
                continue;
            }
            // 没有偏差值或者已完成的，清除偏差原因
            if(ComputeUtil.isLessOrEqual(vo.getDiffValue(), BigDecimal.ZERO) || FillConstant.FINISHED.equals(vo.getFinishState())){
                vo.setDiffType(null);
                vo.setDiffResson(null);
            }
            // 有偏差值且未完成的偏差值，且偏差原因为空的，取前置任务的偏差原因
            if(ComputeUtil.isGreaterThan(vo.getDiffValue(), BigDecimal.ZERO) && !FillConstant.FINISHED.equals(vo.getFinishState()) && vo.getDiffType() == null){
                // 获取前置任务
                DayFillDetailVO preVO = this.getPreVO(codeMap, idMap, detailMap, vo.getStructCode());
                // 为了不再次循环，获取处理后的前置任务，所以这里和前置任务清除偏差原因保持一致
                if(ComputeUtil.isLessOrEqual(preVO.getDiffValue(), BigDecimal.ZERO) || FillConstant.FINISHED.equals(preVO.getFinishState())){
                    continue;
                }
                vo.setDiffType(preVO.getDiffType());
                vo.setDiffResson(preVO.getDiffResson());
            }
            // 偏差大于0，校验偏差原因类型必输
            if(ComputeUtil.isGreaterThan(vo.getDiffValue(), BigDecimal.ZERO) && vo.getDiffType() == null){
                throw new BusinessException(vo.getOutlineNumber() + "[" + vo.getName() + "]偏差日期大于0，请填写偏差原因！");
            }
        }
    }

    /**
     * 因为有实际开始日期的日反馈任务，前置任务关系清空，所以只能根据结构码找到执行计划中前置任务的结构码
     * @param codeMap
     * @param idMap
     * @param detailMap
     * @param structCode
     * @return
     */
    private DayFillDetailVO getPreVO(Map<String, ExecPlanDetailEntity> codeMap, Map<Long, ExecPlanDetailEntity> idMap, Map<String, DayFillDetailVO> detailMap, String structCode) {
        if(!codeMap.containsKey(structCode)){
            return new DayFillDetailVO();
        }
        String PredecessorLink = codeMap.get(structCode).getPredecessorLink();
        if(StringUtils.isEmpty(PredecessorLink)){
            return new DayFillDetailVO();
        }
        JSONArray array = JSON.parseArray(PredecessorLink);
        List<ExecPlanDetailEntity> preList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            if(idMap.containsKey(obj.getLong("PredecessorUID"))){
                preList.add(idMap.get(obj.getLong("PredecessorUID")));
            }
        }
        for(ExecPlanDetailEntity pre : preList){
            if(!detailMap.containsKey(pre.getStructCode())) {
                continue;
            }
            DayFillDetailVO preVO = detailMap.get(pre.getStructCode());
            if(preVO.getDiffType() != null){
                return preVO;
            }
        }
        return new DayFillDetailVO();
    }

    @Override
    public DayFillVO queryDetail(Long id) {
        DayFillEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<DayFillDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<DayFillDetailEntity> progressDetailList = detailService.list(queryWrapper);

        DayFillVO progressVo = BeanMapper.map(progressEntity, DayFillVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<DayFillDetailVO> progressDetailVoList = new ArrayList<>();
            for (DayFillDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(DayFillDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getExecPlan(DayFillVO vo) {
        if (vo.getFillDate().getTime() > new Date().getTime()) {
            throw new BusinessException("填报日期不能大于当前日期");
        }
        Map resMap = new HashMap();
        LambdaQueryWrapper<ExecPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExecPlanEntity::getProjectId, vo.getProjectId());
        ExecPlanEntity execPlanEntity = execPlanService.getOne(queryWrapper);
        if (execPlanEntity == null) {
            throw new BusinessException("该项目没有做计划");
        }
        LambdaQueryWrapper<DayFillEntity> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(DayFillEntity::getProjectId, vo.getProjectId());
        queryWrapper1.eq(DayFillEntity::getFillUserId, vo.getFillUserId());
        queryWrapper1.notIn(DayFillEntity::getBillState, 1, 3);
        if(vo.getId() != null){
            queryWrapper1.ne(DayFillEntity::getId, vo.getId());
        }
        List<DayFillEntity> list = list(queryWrapper1);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目存在未生效单据，不允许新增");
        }
        LambdaQueryWrapper<DayFillEntity> queryWrapper2 = new LambdaQueryWrapper<>();
        queryWrapper2.eq(DayFillEntity::getProjectId, vo.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, vo.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, 1, 3);
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List<DayFillEntity> list2 = list(queryWrapper2);
        if (CollectionUtils.isNotEmpty(list2)) {
            if (vo.getFillDate().getTime() <= list2.get(0).getFillDate().getTime()) {
                throw new BusinessException("填报日期不能小于往期填报日期");
            }
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", execPlanEntity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> execPlanDetailEntities = execPlanDetailService.list(ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList<>());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<ExecPlanDetailVO> detailVOS = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(execPlanDetailEntities)) {
                List<ExecPlanDetailEntity> epds = BeanMapper.mapList(execPlanDetailEntities, ExecPlanDetailEntity.class);
                List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            List<String> leafList = new ArrayList<>();
            getLeaf(leafList, detailVOS);
            List<DayFillDetailVO> tasks = new ArrayList<>();
//            LinkedList<ExecPlanDetailEntity> result = sort(execPlanDetailEntities);
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = BeanMapper.map(epd, DayFillDetailEntity.class);
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
//                dvo.setStart(epd.getPredictStart());
//                dvo.setFinish(epd.getPredictFinish());
                // 预测完成时间初始等于实际完成时间
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() :
                        epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish());
//                dvo.setActualDuration(epd.getDuration());
                // 重算工期
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(dvo.getActualStart() == null ? 0 : 1);
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(true);
//                    dvo.setFixedDate(0);
                } else {
                    dvo.setLeafFlag(false);
//                    dvo.setFixedDate(1);
                }
                dvo.setFixedDate(0);
                // 没有实际开始时间，且是不得早于...开始，且有前置任务或者限制日期小于填报日期的，限制日期改成填报日期，有前置任务会重新排期
                if(dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty(dvo.getPredecessorLink())
                        || (dvo.getLeafFlag() && DateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0))){
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
//                // 前置任务转成文本
//                dvo.setPlanPreLink(this.getPlanPreLink(result, dvo.getPredecessorLink()));
                dvo.setOldPreLink(dvo.getPredecessorLink());
                tasks.add(dvo);
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                } else {
                    finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
                }
            }
            tasks = TreeHelper2.list2Tree(tasks);
            // 处理父级
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            // 前置任务转成文本
            LinkedList<DayFillDetailVO> result = sort(tasks);
            this.dealPlanPreLink(result, tasks);
            resMap.put("Tasks", tasks);
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    /**
     * 树形结构排序
     * @param sourceList
     * @return
     */
    private static LinkedList<DayFillDetailVO> sort(List<DayFillDetailVO> sourceList){
        if(CollectionUtils.isEmpty(sourceList)){
            return new LinkedList<>();
        }
        List<DayFillDetailVO> list = TreeHelper2.tree2List(sourceList);
        LinkedList<DayFillDetailVO> result = new LinkedList<>();
        toSort(list, result, "-1");
        return result;
    }

    private static LinkedList<DayFillDetailVO> toSort(List<DayFillDetailVO> list,
            LinkedList<DayFillDetailVO> result, String parentId){
        if(CollectionUtils.isEmpty(list)){
            return result;
        }
        // 最高层临时存放
        List<DayFillDetailVO> temp = list.stream().filter(x->x.getParentTaskUID().equals(parentId)).collect(Collectors.toList());
        if(temp.size() < 1){
            return result;
        } else {
            // 删除最高层
            list = list.stream().filter(x->!x.getParentTaskUID().equals(parentId)).collect(Collectors.toList());
            // 对最高层排序
            temp = temp.stream().sorted(Comparator.comparing(DayFillDetailVO::getId)).collect(Collectors.toList());
            // 递归
            for(DayFillDetailVO vo : temp){
                result.add(vo);
                toSort(list, result, vo.getUid());
            }
            return result;
        }
    }

    @Override
    public Map getExecPlanMobile(DayFillVO vo) {
        vo.setFillDate(new Date());
        Map resMap = new HashMap();
        LambdaQueryWrapper<ExecPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExecPlanEntity::getProjectId, vo.getProjectId());
        ExecPlanEntity execPlanEntity = execPlanService.getOne(queryWrapper);
        if (execPlanEntity == null) {
            throw new BusinessException("该项目没有做计划");
        }
        LambdaQueryWrapper<DayFillEntity> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(DayFillEntity::getProjectId, vo.getProjectId());
        //queryWrapper1.eq(DayFillEntity::getFillUserId, vo.getFillUserId());
        queryWrapper1.notIn(DayFillEntity::getBillState, 1, 3);
        if(vo.getId() != null){
            queryWrapper1.ne(DayFillEntity::getId, vo.getId());
        }
        List<DayFillEntity> list = list(queryWrapper1);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目存在未生效单据，不允许新增");
        }
        LambdaQueryWrapper<DayFillEntity> queryWrapper2 = new LambdaQueryWrapper<>();
        queryWrapper2.eq(DayFillEntity::getProjectId, vo.getProjectId());
        if(!vo.getFillUserId().equals(303581417601122400L)){
            queryWrapper2.eq(DayFillEntity::getFillUserId, vo.getFillUserId());
        }
        queryWrapper2.in(DayFillEntity::getBillState, 1, 3);
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List<DayFillEntity> list2 = list(queryWrapper2);
        if (CollectionUtils.isNotEmpty(list2)) {
            if (vo.getFillDate().getTime() <= list2.get(0).getFillDate().getTime()) {
                throw new BusinessException("填报日期不能小于往期填报日期");
            }
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", execPlanEntity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> execPlanDetailEntities = execPlanDetailService.list(ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList<>());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<ExecPlanDetailVO> detailVOS = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(execPlanDetailEntities)) {
                List<ExecPlanDetailEntity> epds = BeanMapper.mapList(execPlanDetailEntities, ExecPlanDetailEntity.class);
                List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            List<String> leafList = new ArrayList<>();
            getLeaf(leafList, detailVOS);
            Map<String,String> pmap = new HashMap<>();
            getParentName(pmap,detailVOS,null);
            List<DayFillDetailVO> tasks = new ArrayList<>();
            List<DayFillDetailVO> detailList = new ArrayList<>();
//            LinkedList<ExecPlanDetailEntity> result = sort(execPlanDetailEntities);
            List<DefdocDetailVO> defDocList = feignUtil.getDefDocListById(DefDocIdEnum.偏差原因类型.getCode());
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = BeanMapper.map(epd, DayFillDetailEntity.class);
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
//                dvo.setStart(epd.getPredictStart());
//                dvo.setFinish(epd.getPredictFinish());
                // 预测完成时间初始等于实际完成时间
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() :
                        epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish());
                // 重算工期
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(dvo.getActualStart() == null ? 0 : 1);
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(true);
//                    dvo.setFixedDate(0);
                } else {
                    dvo.setLeafFlag(false);
//                    dvo.setFixedDate(1);
                }
                dvo.setFixedDate(0);
                dvo.setParentName(pmap.get(dvo.getStructCode()));
//                dvo.setDiffTypeName(PlanConstant.DIFF_TYPE.get(dvo.getDiffType()));
                dvo.setDiffTypeName(feignUtil.getDefDocDetail(defDocList, dvo.getDiffType()).getName());
                // 没有实际开始时间，且是不得早于...开始，且有前置任务或者限制日期小于填报日期的，限制日期改成填报日期，有前置任务会重新排期
                if(dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty(dvo.getPredecessorLink())
                        || (dvo.getLeafFlag() && DateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0))){
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
//                // 前置任务转成文本
//                dvo.setPlanPreLink(this.getPlanPreLink(result, dvo.getPredecessorLink()));
                dvo.setOldPreLink(dvo.getPredecessorLink());
                dvo.setShowState(false);
                if (leafList.contains(epd.getStructCode())) {
                    if (dvo.getActualFinish() == null && dvo.getStart().getTime() <= vo.getFillDate().getTime()) {
                        if ((dvo.getEmployeeId() != null && dvo.getEmployeeId().equals(vo.getFillUserId())) || vo.getFillUserId().equals(303581417601122400L)) {
                            if(dvo.getActualStart() != null){
                                dvo.setFinishState(1);
                            }else{
                                dvo.setFinishState(0);
                            }
                            dvo.setShowState(true);
                            detailList.add(Utils.deepCopy(dvo));
                        }
                    }
                }
                tasks.add(Utils.deepCopy(dvo));
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                } else {
                    finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
                }
            }
            tasks = TreeHelper2.list2Tree(tasks);
            // 处理父级
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            // 前置任务转成文本
            LinkedList<DayFillDetailVO> result = sort(tasks);
            this.dealPlanPreLink(result, tasks);
            resMap.put("Tasks", tasks);// 全部
            resMap.put("progressDetailList", TreeHelper2.list2Tree(detailList));// 末级
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    @Override
    public JSONObject projectDiffTypeList(QueryParam param) {
        JSONObject page = new JSONObject();
        String text = param.getSearchText();// 模糊查询
        int current = param.getPageIndex();//第几页
        int size = param.getPageSize();//一页几条
        page.put("current", current);
        page.put("size", size);

        param.getFuzzyFields().add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        List<DayFillEntity> fillList = super.queryList(param);
        if(CollectionUtils.isEmpty(fillList)){
            page.put("records", new ArrayList<>());
            page.put("total", 0);
            page.put("pages", 0);
            return page;
        }

        // 数据准备
        List<Long> ids = fillList.stream().map(DayFillEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, ids));
        List<DayFillDetailEntity> detailList = detailService.queryList(detailParam);

        Map<Long, List<DayFillEntity>> fillMap = fillList.stream().collect(Collectors.groupingBy(DayFillEntity::getProjectId));
        Map<Long, List<DayFillDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(DayFillDetailEntity::getProgressId));

        // 按照“项目+偏差原因类型”维度，查询该项目的【日进度完成情况报告】，按照“偏差原因类型”维度，统计偏差次数、偏差天数，
        // 并计算该“偏差原因类型”在该项目所有偏差类型的占比（∑该偏差原因类型的偏差次数/∑该项目的偏差次数）
        List<Long> orgIds = fillList.stream().map(DayFillEntity::getOrgId).collect(Collectors.toList());
        Map<Long, OrgVO> corpMap = orgUtil.findListByIds(orgIds);
        JSONArray array = new JSONArray();
        for(Long projectId : fillMap.keySet()){
            DayFillEntity fill = fillMap.get(projectId).stream().max(Comparator.comparing(DayFillEntity::getCreateTime)).get();
            JSONObject obj = new JSONObject();
            obj.put("projectId", fill.getProjectId());
            obj.put("corpName", corpMap.containsKey(fill.getOrgId()) ? corpMap.get(fill.getOrgId()).getName() : null);
            obj.put("projectName", fill.getProjectName());
            // 汇总进度填报明细
            this.calculateDiffTypes(fillMap.get(projectId), detailMap, obj);
            array.add(obj);
        }

        // 分页
        int total = array.size();//总条数
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);//有几页
        page.put("records", records);
        page.put("total", total);
        page.put("pages", pages);
        return page;
    }

    @Override
    public JSONArray diffTypeRate(Long projectId) {
        LambdaQueryWrapper<ExecPlanEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ExecPlanEntity::getProjectId, projectId);
        ExecPlanEntity entity = execPlanService.getOne(wrapper);
        JSONArray array = new JSONArray();
        if (entity == null) {
            return array;
        }
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execPlanDetailService.list(ew);
        detailList = detailList.stream().filter(x->x.getDiffType() != null).collect(Collectors.toList());
        Map<Long, List<ExecPlanDetailEntity>> diffTypeMap = detailList.stream().collect(Collectors.groupingBy(ExecPlanDetailEntity::getDiffType));
        List<DefdocDetailVO> defDocList = feignUtil.getDefDocListById(DefDocIdEnum.偏差原因类型.getCode());
        for(Long diffType : diffTypeMap.keySet()){
            JSONObject obj = new JSONObject();
            obj.put("diffType", diffType);
            obj.put("diffTypeName", feignUtil.getDefDocDetail(defDocList, diffType).getName());
            obj.put("num", diffTypeMap.get(diffType).size());
            obj.put("sum", detailList.size());
            obj.put("rate", ComputeUtil.bigDecimalPercent(diffTypeMap.get(diffType).size(), detailList.size(), 0));
            array.add(obj);
        }
        return array;
    }

    /**
     * 汇总进度填报明细
     * @param fillList
     * @param detailMap
     * @param obj
     */
    private void calculateDiffTypes(List<DayFillEntity> fillList, Map<Long, List<DayFillDetailEntity>> detailMap, JSONObject obj) {
        Integer sum = 0;
        for(int i = 0; i < diffTypes.size(); i++){
            Integer num = 0;
            Integer value = 0;
            Long diffType = diffTypes.get(i);
            for(DayFillEntity vo : fillList){
                if(!detailMap.containsKey(vo.getId())){
                    continue;
                }
                List<DayFillDetailEntity> list = detailMap.get(vo.getId()).stream().filter(x->x.getDiffType() != null
                        && x.getDiffType().equals(diffType)).collect(Collectors.toList());
                num = num + list.size();
                BigDecimal diffValue = list.stream().map(DayFillDetailEntity::getDiffValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                value = value + diffValue.intValue();
            }
            sum = sum + num;
            obj.put("diffType0" + i, diffType);
            obj.put("num0" + i, num);
            obj.put("value0" + i, value);
        }
        obj.put("sum", sum);
        for(int i = 0; i < diffTypes.size(); i++){
            Integer num = obj.getIntValue("num0" + i);
            obj.put("rate0" + i, ComputeUtil.bigDecimalPercent(num, sum, 2));
        }
    }

    @Override
    public DayFillVO resetExecPlan(Long id) {
        // 查询日反馈
        DayFillVO fill = this.queryDetail(id);
        List<DayFillDetailVO> progressDetailList = TreeHelper2.tree2List(fill.getProgressDetailList());
        Map<String, DayFillDetailVO> detailMap = progressDetailList.stream().collect(
                Collectors.toMap(DayFillDetailVO::getStructCode, x->x));
        JSONObject calender = DurationUtil.getCalender(fill.getCalendars(), fill.getCalendarUid());
        // 最大生效填报时间
        LambdaQueryWrapper<DayFillEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(DayFillEntity::getProjectId, fill.getProjectId());
        wrapper.in(DayFillEntity::getBillState, 1, 3);
        wrapper.orderByDesc(DayFillEntity::getFillDate);
        List<DayFillEntity> list = super.list(wrapper);
        Date maxDate = CollectionUtils.isEmpty(list) || fill.getFillDate().getTime() > list.get(0).getFillDate().getTime()
                ? fill.getFillDate() : list.get(0).getFillDate();

        // 查询执行计划
        LambdaQueryWrapper<ExecPlanEntity> ew = new LambdaQueryWrapper<>();
        ew.eq(ExecPlanEntity::getProjectId, fill.getProjectId());
        ExecPlanEntity exec = execPlanService.getOne(ew);
        if (exec == null) {
            throw new BusinessException("该项目没有做计划");
        }
        fill.setImportFlag(true);
        fill.setFillVersion(exec.getFillVersion());
        QueryWrapper<ExecPlanDetailEntity> ew2 = new QueryWrapper<>();
        ew2.eq("progress_id", exec.getId());
        ew2.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execPlanDetailService.list(ew2);
        if (detailList.size() <= 0) {
            fill.setProgressDetailList(null);
            fill.setRemovedTasks(progressDetailList);
            return fill;
        }
        // 查询末级
        List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            detailVOList = TreeHelper2.list2Tree(detailVOList);
        }
        List<String> leafList = new ArrayList<>();
        this.getLeaf(leafList, detailVOList);
        // 末级赋值，父级初始化
        List<DayFillDetailVO> tasks = new ArrayList<>();
//        LinkedList<ExecPlanDetailEntity> result = sort(detailList);
        for (ExecPlanDetailEntity detail : detailList) {
            if(!detailMap.containsKey(detail.getStructCode())){
                continue;
            }
            DayFillDetailVO vo = DayFillDetailEntity.convertEntityToVo(BeanMapper.map(detail, DayFillDetailEntity.class));
            // 预测完成时间初始等于实际完成时间
            vo.setStart(detail.getActualStart() != null ? detail.getActualStart() : detail.getPredictStart());
            vo.setFinish(detail.getActualFinish() != null ? detail.getActualFinish() :
                    detail.getEstimateFinish() != null ? detail.getEstimateFinish() : detail.getPredictFinish());
            if (leafList.contains(detail.getStructCode())) {
                vo.setLeafFlag(true);
//                vo.setFixedDate(0);
            } else {
                vo.setLeafFlag(false);
//                vo.setFixedDate(1);
            }
            vo.setFixedDate(0);
//            // 前置任务转成文本
//            vo.setPlanPreLink(this.getPlanPreLink(result, vo.getPredecessorLink()));
            vo.setOldPreLink(vo.getPredecessorLink());
            vo.setShowState(true);
            DayFillDetailVO old = detailMap.get(vo.getStructCode());
            // 有实际开始时间的末级反馈数据等于原数据
            if (vo.getLeafFlag() && old.getActualStart() != null && fill.getFillUserId().equals(InvocationInfoProxy.getUserid())) {
                vo.setActualStart(old.getActualStart());
                vo.setActualFinish(old.getActualFinish());
                vo.setEstimateFinish(old.getEstimateFinish());
                vo.setStart(old.getActualStart() != null ? old.getActualStart() : detail.getPredictStart());
                vo.setFinish(old.getActualFinish() != null ? old.getActualFinish() :
                        old.getEstimateFinish() != null ? old.getEstimateFinish() : detail.getPredictFinish());
//                vo.setDuration(old.getDuration());
//                vo.setDuration(DurationUtil.calculateDuration(vo.getStart(), vo.getFinish(), calender));
                vo.setPercentComplete(old.getPercentComplete());
                vo.setFinishNum(old.getFinishNum());
//                vo.setDiffValue(old.getDiffValue());
                // 偏差时间=预测完成时间-完成时间
                vo.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(vo.getFinish(), vo.getPlanFinish())));
                vo.setDiffType(old.getDiffType());
                vo.setDiffResson(old.getDiffResson());
                vo.setResourceNum(old.getResourceNum());
                vo.setDiffNum(old.getDiffNum());
                if(vo.getActualStart() != null){
                    vo.setPredecessorLink(null);
                }
            }
            // 从执行计划带出来的工期也要根据预测时间重新算，否则预测时间不等于实际完成时间
            vo.setDuration(DurationUtil.calculateDuration(vo.getStart(), vo.getFinish(), calender));
            // 末级预测开始时间小于填报日期，没有实际开始时间，则延后到填报日期
            if(vo.getLeafFlag() && DateUtil.compareDay(vo.getStart(), fill.getFillDate()) < 0 && vo.getActualStart() == null){
                vo.setStart(DateUtil.setHours(fill.getFillDate(), 8));
                vo.setConstraintType(4);
                vo.setConstraintDate(vo.getStart());
            }
            // 没有实际开始时间，且是不得早于...开始，且有前置任务或者限制日期小于填报日期的，限制日期改成填报日期，有前置任务会重新排期
            if(vo.getActualStart() == null && vo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty(vo.getPredecessorLink())
                    || (vo.getLeafFlag() && DateUtil.compareDate(vo.getConstraintDate(), fill.getFillDate()) < 0))){
                vo.setConstraintDate(DateUtil.setHours(fill.getFillDate(), 8));
            }
            vo.setShowState(old.getShowState());
            vo.setPlanDuration(detail.getDuration());
            vo.setStartSourceType(vo.getActualStart() == null ? 0 : 1);
//            vo.setFixedDate(0);
            tasks.add(vo);
        }
        tasks = TreeHelper2.list2Tree(tasks);
        // 处理父级
        this.dealParentTask(calender, maxDate, tasks);
        // 前置任务转成文本
        LinkedList<DayFillDetailVO> result = sort(tasks);
        this.dealPlanPreLink(result, tasks);
        fill.setProgressDetailList(tasks);
//        fill.setTasks(tasks);
        return fill;
    }

    /**
     * 处理父级任务
     * @param calender
     * @param maxDate
     * @param tasks
     */
    private void dealParentTask(JSONObject calender, Date maxDate, List<DayFillDetailVO> tasks) {
        for(DayFillDetailVO task : tasks){
            if(CollectionUtils.isEmpty(task.getChildren())){
                continue;
            } else {
                this.dealParentTask(calender, maxDate, task.getChildren());
            }
            // 汇总子级时间加上本级
            List<DayFillDetailVO> childList = Utils.deepCopy(task.getChildren());
//            childList.add(task);
            Date Finish = task.getFinish();
            task.setStart(childList.stream().map(DayFillDetailVO::getStart).filter(Objects::nonNull).min(Comparator.comparing(x->x)).orElse(null));
            task.setFinish(childList.stream().map(DayFillDetailVO::getFinish).filter(Objects::nonNull).max(Comparator.comparing(x->x)).orElse(null));
            task.setDuration(DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender));
            task.setActualStart(task.getStart());
            // 所有末级未填写实际开始时间，父级实际开始时间为空
            if(childList.stream().filter(x->x.getActualStart() != null).count() == 0){
//                continue;
                task.setActualStart(null);
            }
            // 有实际完成日期的，需要固定工期
            if(task.getActualFinish() != null){
                task.setFixedDate(1);
            }
            // 增加虚拟子任务
            // task.getPlanDuration() > task.getDuration()
            // 未完成 + 父任务的完成时间不等于子任务最大完成时间 + 父任务的计划完成时间不等于子任务最大计划完成时间，增加虚拟子任务
            Date maxPlanFinish = childList.stream().map(DayFillDetailVO::getPlanFinish).filter(Objects::nonNull).max(Comparator.comparing(x->x)).orElse(null);
            if(!DateUtil.isSameDay(Finish, task.getFinish()) && task.getActualFinish() == null
                    && !DateUtil.isSameDay(maxPlanFinish, task.getPlanFinish())){
                this.addVirtualVO(task, calender);
                // 增加虚拟子任务，完成时间、工期重新计算
                childList = Utils.deepCopy(task.getChildren());
                task.setFinish(childList.stream().map(DayFillDetailVO::getFinish).filter(Objects::nonNull).max(Comparator.comparing(x->x)).orElse(null));
                task.setDuration(DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender));
            }
            // 末级未填写百分比，父级百分比等于0
//            double average = task.getChildren().stream().map(DayFillDetailVO::getPercentComplete).collect(Collectors.averagingInt(Integer::intValue));
            if(childList.stream().filter(x->x.getPercentComplete() != null && x.getPercentComplete() > 0).count() == 0){
//                continue;
                task.setPercentComplete(0);
            }
            if(childList.stream().filter(x->x.getActualFinish() == null).count() == 0){
                task.setActualFinish(task.getFinish());
                task.setEstimateFinish(null);
            } else {
                task.setEstimateFinish(task.getFinish());
                task.setActualFinish(null);
            }
            // 偏差时间=预测完成时间-完成时间
            task.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(task.getFinish(), task.getPlanFinish())));
            // 根据时间计算完成百分比
            BigDecimal percentComplete = this.calculatePercentComplete(maxDate, task, calender);
            task.setPercentComplete(percentComplete.intValue());
            // 完成工程量=实际完成百分比*工程量
            BigDecimal finishNum = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(new BigDecimal(task.getPercentComplete()), new BigDecimal("100")), task.getPlanNum());
            task.setFinishNum(finishNum);
            // 实际开始时间为空，完成百分比等于0，实际完成时间和预计完成时间也置为控
            if(task.getActualStart() == null || task.getPercentComplete() == 0){
                task.setActualFinish(null);
                task.setEstimateFinish(null);
                task.setFinishNum(null);
            }
        }
    }

    /**
     * 增加虚拟子任务
     * 如果计划工期大于计算后工期，说明任务未完全分解，需增加虚拟子任务，保证父级非固定工期（可以按照前置任务关系排程），且工期不缩短
     * @param task
     */
    private void addVirtualVO(DayFillDetailVO task, JSONObject calender) {
        DayFillDetailVO vo = new DayFillDetailVO();
        vo.setUid(String.valueOf(IdWorker.getId()));
        vo.setParentTaskUID(task.getUid());
        vo.setStart(task.getStart());
        // 根据日历按照开始时间+工期计算完成时间
        Date Finish = DurationUtil.calculateFinish(task.getStart(), task.getPlanDuration(), calender);
        vo.setFinish(Finish);
        vo.setDuration(task.getPlanDuration());
        vo.setActualStart(task.getActualStart());
        vo.setLeafFlag(true);
        vo.setFixedDate(0);
        vo.setShowState(false);
        vo.setId(task.getChildren().stream().max(Comparator.comparing(DayFillDetailVO::getId)).get().getId());
        // 取预测开始日期或计划开始日期最小值作为虚拟子任务的前置任务
        DayFillDetailVO min = task.getChildren().stream().sorted(Comparator.comparing(DayFillDetailVO::getStart).
                thenComparing(DayFillDetailVO::getPlanStart)).findFirst().orElse(null);
        if(min != null){
            JSONArray PredecessorLink = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("LagFormat", 7);
            obj.put("PredecessorUID", min.getUid());
            obj.put("Type", 3);
            obj.put("TaskUID", vo.getUid());
            obj.put("LinkLag", 0);
            PredecessorLink.add(obj);
            vo.setPredecessorLink(PredecessorLink);
        }
        List<DayFillDetailVO> children = task.getChildren();
        children.add(vo);
    }

    /**
     * 处理前置任务转文本
     * @param result
     * @param tasks
     */
    private void dealPlanPreLink(LinkedList<DayFillDetailVO> result, List<DayFillDetailVO> tasks) {
        for(DayFillDetailVO task : tasks){
            // 前置任务转文本
            task.setPlanPreLink(TreeUtils.getPlanPreLink(result, task.getPredecessorLink()));
            if(CollectionUtils.isNotEmpty(task.getChildren())){
                this.dealPlanPreLink(result, task.getChildren());
            }
        }
    }

    /**
     * 根据时间计算完成百分比
     * @param fillDate
     * @param task
     * @return
     */
    private BigDecimal calculatePercentComplete(Date fillDate, DayFillDetailVO task, JSONObject calender) {
//        // 完成百分比 =（数据填写时间-实际开始时间 + 1）/（预测完成时间-实际开始时间 + 1）
//        BigDecimal percentComplete = ComputeUtil.bigDecimalPercent(DateUtil.getSubDay(fillDate, task.getActualStart()),
//                DateUtil.getSubDay(task.getFinish(), task.getActualStart()), 0);
        if(task.getActualStart() == null){
            return BigDecimal.ZERO;
        }
        // 完成百分比 = 1 - (预计完成日期 - 开始日期 - (填报日期 - 开始日期)) / 计划工期
        Integer duration = DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender);
        Integer fillDuration = DurationUtil.calculateDuration(task.getStart(), fillDate, calender);
        BigDecimal percentComplete = ComputeUtil.safeSub(ComputeUtil.toBigDecimal(100), ComputeUtil.bigDecimalPercent(
                ComputeUtil.safeSub(ComputeUtil.toBigDecimal(duration), ComputeUtil.toBigDecimal(fillDuration)),
                ComputeUtil.toBigDecimal(task.getPlanDuration()), 0));
        // 当任务已填写了实际开始、实际完成时，完成百分比=100%；
        if(task.getActualStart() != null && task.getActualFinish() != null){
            percentComplete = new BigDecimal("100");
        }
        // 当任务未填写实际开始、预计完成、实际完成时，完成百分比=0；
        if(task.getActualStart() == null && task.getActualFinish() == null && task.getEstimateFinish() == null){
            percentComplete = BigDecimal.ZERO;
        }
        if(ComputeUtil.isGreaterThan(percentComplete, new BigDecimal("100"))){
            percentComplete = new BigDecimal("100");
        }
        // 百分比不能小于0
        if(ComputeUtil.isLessThan(percentComplete, new BigDecimal("0"))){
            percentComplete = new BigDecimal("0");
        }
        return percentComplete;
    }

    private void getParents(Map<Long, ExecPlanDetailEntity> res, List<ExecPlanDetailEntity> list, Long pid) {
        if (pid != -1) {
            for (ExecPlanDetailEntity epd : list) {
                if (pid == epd.getId()) {
                    res.put(epd.getId(), epd);
                    if (epd.getParentId() != -1) {
                        getParents(res, list, epd.getParentId());
                    }
                }
            }
        }
    }

    private void getLeaf(List<String> res, List<ExecPlanDetailVO> detailVOS) {
        for (ExecPlanDetailVO epd : detailVOS) {
            if (CollectionUtils.isNotEmpty(epd.getChildren())) {
                getLeaf(res, epd.getChildren());
            } else {
                res.add(epd.getStructCode());
            }
        }
    }
    private void getParentName(Map<String,String> pmap,List<ExecPlanDetailVO> detailVOS, String pname) {
        for (ExecPlanDetailVO epd : detailVOS) {
            String name = epd.getName();
            if(StringUtils.isNotBlank(pname)){
                pmap.put(epd.getStructCode(),pname);
                name = pname+"/"+name;
            }
            if (CollectionUtils.isNotEmpty(epd.getChildren())) {
                getParentName(pmap, epd.getChildren(),name);
            }
        }
    }

}
