package com.ejianc.business.jlprogress.quality.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.vo.DetectReportVO;

/**
 * 质量检测-检测报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("detectReport")
public class DetectReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "JCBG";//此处需要根据实际修改

    @Autowired
    private IDetectReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DetectReportVO> saveOrUpdate(@RequestBody DetectReportVO saveOrUpdateVO) {
        DetectReportVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DetectReportVO> queryDetail(Long id) {
    	DetectReportEntity entity = service.selectById(id);
    	DetectReportVO vo = BeanMapper.map(entity, DetectReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DetectReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DetectReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DetectReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DetectReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("entrustName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplyName");
        fuzzyFields.add("customerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<DetectReportEntity> page = service.queryPage(param,false);
        IPage<DetectReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DetectReportVO> detectReportVOS = BeanMapper.mapList(page.getRecords(), DetectReportVO.class);
        detectReportVOS.stream().forEach(vo -> {
            vo.setEntrustTypeStr(vo.getEntrustType()==1?"外委":"内委");
        });
        pageData.setRecords(detectReportVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DetectReportVO> records = new ArrayList<>();
        CommonResponse<IPage<DetectReportVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()){
            records = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        records.stream().forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());

        });
        beans.put("records", records);
        ExcelExport.getInstance().export("DetectReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDetectReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DetectReportVO>> refDetectReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<DetectReportEntity> page = service.queryPage(param,false);
        IPage<DetectReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DetectReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDetectReportDataBySupplyName", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DetectReportVO>> refDetectReportDataBySupplyName(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            Long supplyId = _con.getLong("supplyId");
            if(supplyId == null){
                return CommonResponse.error("supplyId不能为空!");
            }
            param.getParams().put("supplyId", new Parameter(QueryParam.EQ, supplyId));
        }
        IPage<DetectReportEntity> page = service.queryPage(param,false);
        IPage<DetectReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DetectReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
