/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.mapper.CheckMapper;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    @Override
    public JSONObject getCheckDataByContractId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CheckEntity::getContractId, (Object)contractId);
        queryWrapper.in(CheckEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        jsonObject.put("checkList", (Object)list);
        jsonObject.put("checkState", (Object)(CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0 ? "\u5df2\u9a8c\u6536" : "\u672a\u9a8c\u6536"));
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> getCheckDataByContractIdList(List<Long> ids) {
        HashMap<Long, JSONObject> collectMap = new HashMap<Long, JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(CheckEntity::getContractId, ids);
        queryWrapper.in(CheckEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<CheckEntity>> checkDataMap = list.stream().collect(Collectors.groupingBy(CheckEntity::getContractId));
            for (Long contractId : checkDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("checkList", checkDataMap.get(contractId));
                jsonObject.put("checkState", (Object)(CollectionUtils.isNotEmpty((Collection)checkDataMap.get(contractId)) && checkDataMap.get(contractId).size() > 0 ? "\u5df2\u9a8c\u6536" : "\u672a\u9a8c\u6536"));
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}

