/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.handler.IPlanHandler;
import com.ejianc.business.jlprogress.progress.handler.PlanLockUtil;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DayFillHandler
implements IPlanHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDayFillService service;
    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;

    @Override
    public ExecPlanEntity handle(Long id) {
        DayFillEntity source = (DayFillEntity)((Object)this.service.selectById(id));
        if (source == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u65e5\u8fdb\u5ea6\u53cd\u9988\uff01");
        }
        QueryWrapper ew = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)id)).orderByAsc((Object)"tid");
        List sourceList = this.detailService.list((Wrapper)ew);
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)source.getProjectId())));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u751f\u6548\u603b\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        Boolean lock = PlanLockUtil.getLock(source.getProjectId());
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u6267\u884c\u8ba1\u5212\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            List<ExecPlanDetailEntity> saveList = this.transferSaveList(sourceList, detailList, source.getFillDate());
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.execDetailService.saveOrUpdateBatch(saveList);
            }
            data.setAllList(detailList);
            Integer fillVersion = data.getFillVersion() == null ? 1 : data.getFillVersion() + 1;
            data.setFillVersion(fillVersion);
            data.setFillTime(new Date());
            this.execService.saveOrUpdate((Object)data);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u65e5\u8fdb\u5ea6\u53cd\u9988id-{}\u7ed9\u6267\u884c\u8ba1\u5212id-{} \u5f02\u5e38\uff0c", new Object[]{id, data.getId(), e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.booleanValue()) {
                PlanLockUtil.releaseLock(source.getProjectId());
            }
        }
        return data;
    }

    private List<ExecPlanDetailEntity> transferSaveList(List<DayFillDetailEntity> sourceList, List<ExecPlanDetailEntity> detailList, Date fillDate) {
        ArrayList<ExecPlanDetailEntity> saveList = new ArrayList<ExecPlanDetailEntity>();
        Map<String, DayFillDetailEntity> sourceMap = sourceList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getStructCode())).collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        detailList.forEach(vo -> {
            if (sourceMap.containsKey(vo.getStructCode())) {
                DayFillDetailEntity source = (DayFillDetailEntity)((Object)((Object)sourceMap.get(vo.getStructCode())));
                vo.setActualStart(source.getActualStart());
                vo.setActualFinish(source.getActualFinish());
                if (vo.getActualFinish() != null) {
                    vo.setEstimateFinish(null);
                } else {
                    vo.setEstimateFinish(source.getEstimateFinish());
                }
                vo.setPredictStart(source.getStart());
                vo.setPredictFinish(source.getFinish());
                vo.setPredictDuration(source.getDuration());
                vo.setDiffType(source.getDiffType());
                vo.setDiffResson(source.getDiffResson());
                vo.setResourceNum(source.getResourceNum());
                vo.setDiffValue(source.getDiffValue());
                vo.setDiffNum(ComputeUtil.safeSub((BigDecimal)source.getResourceNum(), (BigDecimal)vo.getNeedNum()));
                vo.setPercentComplete(source.getPercentComplete());
                vo.setFinishNum(source.getFinishNum());
                Integer finishState = 0;
                if (vo.getActualStart() != null) {
                    finishState = vo.getActualFinish() == null ? Integer.valueOf(2) : Integer.valueOf(1);
                }
                vo.setFinishState(finishState);
                vo.setFillDate(fillDate);
                saveList.add((ExecPlanDetailEntity)((Object)vo));
            }
        });
        return saveList;
    }

    @Override
    public ExecPlanEntity handleRollback(Long id) {
        Boolean lock;
        ExecPlanEntity data;
        DayFillEntity entity = (DayFillEntity)((Object)this.service.selectById(id));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        wrapper.ne((Object)"id", (Object)id);
        wrapper.orderByDesc((Object)"fill_version");
        List list = this.service.list((Wrapper)wrapper);
        DayFillEntity source = list.stream().findFirst().orElse(null);
        if (source != null && entity.getFillVersion() < source.getFillVersion()) {
            throw new BusinessException("\u975e\u8be5\u9879\u76ee\u4e0b\u6700\u65b0\u751f\u6548\u65e5\u8fdb\u5ea6\u53cd\u9988\u3010" + source.getBillCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        ArrayList<DayFillDetailEntity> sourceList = new ArrayList();
        if (source != null) {
            QueryWrapper ew = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)source.getId())).orderByAsc((Object)"tid");
            sourceList = this.detailService.list((Wrapper)ew);
        }
        if ((data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)entity.getProjectId())))) == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u751f\u6548\u603b\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        if (source == null) {
            for (ExecPlanDetailEntity detail : detailList) {
                DayFillDetailEntity vo = new DayFillDetailEntity();
                vo.setStructCode(detail.getStructCode());
                vo.setPercentComplete(0);
                vo.setStart(detail.getPlanStart());
                vo.setFinish(detail.getPlanFinish());
                sourceList.add(vo);
            }
        }
        if (!(lock = PlanLockUtil.getLock(entity.getProjectId())).booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u6267\u884c\u8ba1\u5212\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            List<ExecPlanDetailEntity> saveList = this.transferSaveList(sourceList, detailList, null);
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.execDetailService.saveOrUpdateBatch(saveList);
            }
            data.setAllList(detailList);
            Integer fillVersion = data.getFillVersion() == null ? 0 : data.getFillVersion() - 1;
            data.setFillVersion(fillVersion);
            data.setFillTime(new Date());
            this.execService.saveOrUpdate((Object)data);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u65e5\u8fdb\u5ea6\u53cd\u9988id-{}\u7ed9\u6267\u884c\u8ba1\u5212id-{} \u5f02\u5e38\uff0c", new Object[]{id, data.getId(), e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.booleanValue()) {
                PlanLockUtil.releaseLock(entity.getProjectId());
            }
        }
        return data;
    }

    @Override
    public ExecPlanEntity handleUpdate(Long id) {
        return null;
    }
}

