package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.vo.RecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.service.IRecordService;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 浦江设备管理-调拨记录表
 *
 * @author generator
 */
@Service("recordService")
public class RecordServiceImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements IRecordService {

    @Override
    public List<RecordVO> quueryRecord(Page page, QueryWrapper wrapper) {
        return baseMapper.quueryRecord(page, wrapper);
    }

    @Override
    public List<RecordVO> queryAllotList(Long sourceBillId) {
        return baseMapper.queryAllotList(sourceBillId);
    }

    @Override
    public void delete(Long billId) {
        baseMapper.deleteBySourceId(billId);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        baseMapper.deleteBySourceIds(ids);
    }

    @Override
    public List<RecordVO> selectDetails(Long id, String billCode) {
        LambdaQueryWrapper<RecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RecordEntity::getSourceBillId, id).eq(RecordEntity::getSourceBillCode, billCode)
               .in(RecordEntity::getRecordType,RecordTypeEnum.登记.getCode(),RecordTypeEnum.调拨出.getCode(),RecordTypeEnum.处置.getCode());
        List<RecordEntity> list = baseMapper.selectList(wrapper);

        List<RecordEntity> recordEntityList = list.stream().sorted(Comparator.comparing(RecordEntity::getCreateTime)).collect(Collectors.toList());
        List<RecordVO> recordVOS = BeanMapper.mapList(recordEntityList, RecordVO.class);
        return recordVOS;
    }
}
