package com.ejianc.business.jlprogress.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.labor.bean.AttendanceEntity;
import com.ejianc.business.jlprogress.labor.service.IAttendanceService;
import com.ejianc.business.jlprogress.labor.vo.AttendanceVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 劳务实名制-考勤记录
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("attendance")
public class AttendanceController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttendanceService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 保存或更新
     *
     * @param saveOrUpdateVO 保存或更新vo
     *
     * @return {@link CommonResponse}<{@link AttendanceVO}>
     */
    @PostMapping(value = "/saveOrUpdate")
    public CommonResponse<AttendanceVO> saveOrUpdate(@RequestBody AttendanceVO saveOrUpdateVO) {
        AttendanceEntity entity = BeanMapper.map(saveOrUpdateVO, AttendanceEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                // entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        AttendanceVO vo = BeanMapper.map(entity, AttendanceVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    /**
     * 查询详情
     *
     * @param id id
     *
     * @return {@link CommonResponse}<{@link AttendanceVO}>
     */
    @GetMapping(value = "/queryDetail")
    public CommonResponse<AttendanceVO> queryDetail(Long id) {
        AttendanceEntity entity = service.selectById(id);
        AttendanceVO vo = BeanMapper.map(entity, AttendanceVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * 批量删除单据
     *
     * @param vos vos
     *
     * @return {@link CommonResponse}<{@link String}>
     */
    @PostMapping(value = "/delete")
    public CommonResponse<String> delete(@RequestBody List<AttendanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AttendanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AttendanceVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * 按个人统计
     *
     * @param param 参数
     *
     * @return {@link CommonResponse}<{@link IPage}<{@link AttendanceVO}>>
     */
    @PostMapping(value = "/queryPageByPerson")
    public CommonResponse<IPage<AttendanceVO>> queryPageByPerson(@RequestBody QueryParam param) {
        // 模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        // 本下组织
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Map<String, Parameter> params = param.getParams();
        String startDate = null;
        String endDate = null;
        // punchCardDate
        if(params.containsKey("punchCardDate") && params.get("punchCardDate") != null){
            Parameter punchCardDate = params.get("punchCardDate");
            Object punchCardDateStr = punchCardDate.getValue();
            String[] dateArr = punchCardDateStr.toString().split(",");
            startDate = dateArr[0];
            endDate = dateArr[1];
            params.remove("punchCardDate");
        }

        QueryWrapper<AttendanceEntity> wrapper = changeToQueryWrapper(param);
        Page<AttendanceEntity> p = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<AttendanceEntity> page = service.queryPageByPerson(p, wrapper, startDate, endDate);

        List<AttendanceEntity> pageRecords = page.getRecords();
        List<AttendanceVO> records = BeanMapper.mapList(pageRecords, AttendanceVO.class);
        IPage<AttendanceVO> result = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success("查询列表数据成功！", result);
    }


    /**
     * 按考勤记录统计
     *
     * @param param 参数
     *
     * @return {@link CommonResponse}<{@link IPage}<{@link AttendanceVO}>>
     */
    @PostMapping(value = "/queryPageByRecord")
    public CommonResponse<IPage<AttendanceVO>> queryPageByRecord(@RequestBody QueryParam param) {
        // 模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        // 本下组织
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        QueryWrapper<AttendanceEntity> wrapper = changeToQueryWrapper(param);
        wrapper.orderByDesc("punch_card_date", "create_time", "name");

        Page<AttendanceEntity> p = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<AttendanceEntity> page = service.page(p, wrapper);

        List<AttendanceEntity> pageRecords = page.getRecords();
        List<AttendanceVO> records = BeanMapper.mapList(pageRecords, AttendanceVO.class);
        IPage<AttendanceVO> result = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success("查询列表数据成功！", result);
    }


    /**
     * 按个人统计导出
     *
     * @param param    参数
     * @param response 响应
     */
    @PostMapping(value = "excelExportByPerson")
    public void excelExportByPerson(@RequestBody QueryParam param, HttpServletResponse response) {
        // 导出所有数据
        param.setPageSize(-1);
        // 模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        // 本下组织
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map<String, Parameter> params = param.getParams();
        String startDate = null;
        String endDate = null;
        // punchCardDate
        if(params.containsKey("punchCardDate") && params.get("punchCardDate") != null){
            Parameter punchCardDate = params.get("punchCardDate");
            Object punchCardDateStr = punchCardDate.getValue();
            String[] dateArr = punchCardDateStr.toString().split(",");
            startDate = dateArr[0];
            endDate = dateArr[1];
            params.remove("punchCardDate");
        }

        QueryWrapper<AttendanceEntity> wrapper = changeToQueryWrapper(param);
        Page<AttendanceEntity> p = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<AttendanceEntity> page = service.queryPageByPerson(p, wrapper, startDate, endDate);
        List<AttendanceVO> list = BeanMapper.mapList(page.getRecords(), AttendanceVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendancePerson-export.xlsx", beans, response);
    }


    /**
     * 按考勤记录统计导出
     *
     * @param param    参数
     * @param response 响应
     */
    @PostMapping(value = "excelExportByRecord")
    public void excelExportByRecord(@RequestBody QueryParam param, HttpServletResponse response) {
        // 导出所有数据
        param.setPageSize(-1);
        // 模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        // 本下组织
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        QueryWrapper<AttendanceEntity> wrapper = changeToQueryWrapper(param);
        wrapper.orderByDesc("punch_card_date", "create_time", "name");

        Page<AttendanceEntity> p = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<AttendanceEntity> page = service.page(p, wrapper);

        List<AttendanceVO> list = BeanMapper.mapList(page.getRecords(), AttendanceVO.class);
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (AttendanceVO attendanceVO : list) {
                attendanceVO.setRemoteFlagName(attendanceVO.getRemoteFlag() != null && attendanceVO.getRemoteFlag() == 0 ? "否" : "是");
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendanceRecord-export.xlsx", beans, response);
    }


    /**
     * 参照
     *
     * @param pageNumber   页码
     * @param pageSize     页面大小
     * @param condition    条件
     * @param searchObject 搜索对象
     * @param searchText   搜索文本
     *
     * @return {@link CommonResponse}<{@link IPage}<{@link AttendanceVO}>>
     */
    @GetMapping(value = "/refAttendanceData")
    public CommonResponse<IPage<AttendanceVO>> refAttendanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AttendanceEntity> page = service.queryPage(param, false);
        IPage<AttendanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AttendanceVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
