package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.DisposeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.DisposeMapper;
import com.ejianc.business.jlprogress.quality.bean.DisposeEntity;
import com.ejianc.business.jlprogress.quality.service.IDisposeService;

/**
 * 质量检测-不合计品处置单
 * 
 * @author generator
 * 
 */
@Service("disposeService")
public class DisposeServiceImpl extends BaseServiceImpl<DisposeMapper, DisposeEntity> implements IDisposeService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROGRESS_DISPOSE";//此处需要根据实际修改
    @Autowired
    private IProcessCheckService processCheckService;

    @Autowired
    private IFinishedCheckService finishedCheckService;

    @Autowired
    private IDetectReportService detectReportService;

    @Override
    public DisposeVO saveOrUpdate(DisposeVO saveOrUpdateVO) {
        DisposeEntity entity = BeanMapper.map(saveOrUpdateVO, DisposeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        private Integer useState; // 引用标识0-未引用1-已引用
//        private Integer referenceFlag; // 是否被引用 0-未引用,1-已引用

        //退回之前的引用状态
        if (entity.getId() != null){
            DisposeEntity disposeEntity = super.selectById(entity.getId());
            if (disposeEntity.getType() == 1){
                ProcessCheckEntity processCheckEntity = processCheckService.selectById(disposeEntity.getCheckId());
                if (processCheckEntity != null){
                    processCheckEntity.setUseState(0);
                    processCheckService.updateById(processCheckEntity);
                }

            }
            if (disposeEntity.getType() == 2){
                FinishedCheckEntity finishedCheckEntity = finishedCheckService.selectById(disposeEntity.getCheckId());
                if (finishedCheckEntity != null){
                    finishedCheckEntity.setUseState(0);
                    finishedCheckService.updateById(finishedCheckEntity);
                }

            }
            if (disposeEntity.getType() == 3){
                DetectReportEntity detectReportEntity = detectReportService.selectById(disposeEntity.getCheckId());
                if (detectReportEntity != null){
                    detectReportEntity.setReferenceFlag(0);
                    detectReportService.updateById(detectReportEntity);
                }

            }
        }

        //回写引用状态
        if (entity.getType() == 1){
            ProcessCheckEntity processCheckEntity = processCheckService.selectById(entity.getCheckId());
            if (processCheckEntity != null){
                processCheckEntity.setUseState(1);
                processCheckService.updateById(processCheckEntity);
            }

        }
        if (entity.getType() == 2){
            FinishedCheckEntity finishedCheckEntity = finishedCheckService.selectById(entity.getCheckId());
            if (finishedCheckEntity != null){
                finishedCheckEntity.setUseState(1);
                finishedCheckService.updateById(finishedCheckEntity);
            }

        }
        if (entity.getType() == 3){
            DetectReportEntity detectReportEntity = detectReportService.selectById(entity.getCheckId());
            if (detectReportEntity != null){
                detectReportEntity.setReferenceFlag(1);
                detectReportService.updateById(detectReportEntity);
            }

        }

        super.saveOrUpdate(entity, false);
        DisposeVO vo = BeanMapper.map(entity, DisposeVO.class);
        return vo;
    }
}
