package com.ejianc.business.jlprogress.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.quality.bean.WorkTimeDetailEntity;
import com.ejianc.business.jlprogress.quality.service.IWorkTimeDetailService;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeDetailVO;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.WorkTimeMapper;
import com.ejianc.business.jlprogress.quality.bean.WorkTimeEntity;
import com.ejianc.business.jlprogress.quality.service.IWorkTimeService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 质量检测-工时结算-主表
 *
 * @author generator
 */
@Service("workTimeService")
public class WorkTimeServiceImpl extends BaseServiceImpl<WorkTimeMapper, WorkTimeEntity> implements IWorkTimeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String GSJS_MNY_PARAM_CODE = "P-9Z24R90010";//【目标成本-现场施工费】管控【实际现场施工费】
    @Autowired
    private ITargetApi targetApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IWorkTimeDetailService detailService;

    @Override
    public ParamsCheckVO checkParams(WorkTimeVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【目标成本-零件人工工时】管控【零件实际生产工时】

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOS.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    private Collection<? extends ParamsCheckVO> checkParamsByMny(WorkTimeVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        List<WorkTimeDetailVO> list = vo.getWorkTimeDetailList();
        List<WorkTimeDetailVO> resList = list.stream()
                // 过滤掉rowState为"del"的数据
                .filter(e -> !"del".equals(e.getRowState()))
                // 按照id进行分组，由于需要合并number和mny，这里需要使用Collectors.toMap来进行分组聚合
                .collect(Collectors.toMap(
                        detail -> detail.getProjectId() + "-" + detail.getWbsId(), // 获取key（id）
                        e -> e, // 获取value（整个Entity对象）
                        (e1, e2) -> { // 解决冲突的方法，即合并两个Entity实例
                            // 这里我们合并number和mny属性
                            e1.setCountTime(e1.getCountTime().add(e2.getCountTime()));
                            return e1;
                        }
                )).values().stream()
                // 收集结果到一个新的List
                .collect(Collectors.toList());

        List<Long> projectIds = list.stream().distinct().map(WorkTimeDetailVO::getProjectId).collect(Collectors.toList()); // 项目ids
        List<Long> productIds = list.stream().distinct().map(WorkTimeDetailVO::getWbsId).collect(Collectors.toList()); // 产品ids

        //1.查询目标成本 零件人工工时
        CommonResponse<List<QueryTargetDataVO>> targetData = targetApi.getLaborTimeByProjectIds(projectIds, productIds);
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标成本费用信息失败！");
        }

        //未编制目标成本或目标成本中没有零件人工工时时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }
        // 项目加产品确认目标成本值
        Map<String, BigDecimal> targetNumMap = targetDataList.stream().collect(Collectors.toMap(t -> t.getProjectId() + "-" + t.getProductId(), t -> t.getNum()));

        // 查询项目+产品的所有工时子表数据
        QueryWrapper<WorkTimeDetailEntity> wrapper = new QueryWrapper<WorkTimeDetailEntity>();
        wrapper.in("project_id", projectIds).in("wbs_id", productIds);
        if (null != vo.getId() && 0 != vo.getId()) {
            wrapper.ne("work_time_id", vo.getId());
        }
        List<WorkTimeDetailEntity> detailList = detailService.list(wrapper);


        // 统计项目+产品的工时统计
        Map<String, BigDecimal> totalNumMap = new HashMap<>();
        for (WorkTimeDetailEntity detail : detailList) {
            BigDecimal num = totalNumMap.get(detail.getProjectId() + "-" + detail.getWbsId());
            if (num == null) {
                totalNumMap.put(detail.getProjectId() + "-" + detail.getWbsId(), detail.getCountTime());
            } else {
                totalNumMap.put(detail.getProjectId() + "-" + detail.getWbsId(), num.add(detail.getCountTime()));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(GSJS_MNY_PARAM_CODE, vo.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> maxParamVOS = billParamByCode.getData();
        logger.info("【目标成本-零件人工工时】管控【零件实际生产工时】：" + JSONObject.toJSONString(maxParamVOS));

        for (BillParamVO maxParamVO : maxParamVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();// 高价
            List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型

            // 控制方式为none时不需要控制
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                continue;
            }

            for (WorkTimeDetailVO detail : resList) {
                BigDecimal targetTime = targetNumMap.get(detail.getProjectId() + "-" + detail.getWbsId()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                if (targetTime == null) {
                    continue;
                }
                BigDecimal countTime = detail.getCountTime().setScale(2, BigDecimal.ROUND_HALF_DOWN);
                BigDecimal totalTime = totalNumMap.get(detail.getProjectId() + "-" + detail.getWbsId());
                totalTime = (totalTime == null) ? countTime : totalTime.add(countTime);
                totalTime= ComputeUtil.safeDiv(totalTime,BigDecimal.valueOf(60)).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                BigDecimal roleValue = maxParamVO.getRoleValue().setScale(2, BigDecimal.ROUND_HALF_DOWN);
                if (targetTime.multiply(maxParamVO.getRoleValue().divide(BigDecimal.valueOf(100))).compareTo(totalTime) < 0) {
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("【" + detail.getProjectName() + "】 + 【" + detail.getWbsName() + "】 生产工时超额预警");
                    paramsCheckDsVO.setWarnName("结算工时大于目标工时");
                    StringBuffer stringBuffer = new StringBuffer();
                    String text = "超出工时=" + totalTime + "-" + targetTime + "*" + roleValue + "=" + totalTime.subtract(targetTime.multiply(roleValue.divide(BigDecimal.valueOf(100)))).setScale(2, BigDecimal.ROUND_HALF_DOWN) + "小时";
                    String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                    stringBuffer.append("累计生产工时：").append(totalTime).append("小时")
                            .append("，目标成本工时：").append(targetTime).append("小时")
                            .append("，管控比例：").append(roleValue).append("%，")
                            .append(redText);
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);

        }

        return paramsCheckVOS;
    }
}
