/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlprogress.quality.bean.WorkTimeDetailEntity;
import com.ejianc.business.jlprogress.quality.bean.WorkTimeEntity;
import com.ejianc.business.jlprogress.quality.mapper.WorkTimeMapper;
import com.ejianc.business.jlprogress.quality.service.IWorkTimeDetailService;
import com.ejianc.business.jlprogress.quality.service.IWorkTimeService;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeDetailVO;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workTimeService")
public class WorkTimeServiceImpl
extends BaseServiceImpl<WorkTimeMapper, WorkTimeEntity>
implements IWorkTimeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String GSJS_MNY_PARAM_CODE = "P-9Z24R90010";
    @Autowired
    private ITargetApi targetApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IWorkTimeDetailService detailService;

    @Override
    public ParamsCheckVO checkParams(WorkTimeVO vo) {
        ArrayList<? extends ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOS.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    private Collection<? extends ParamsCheckVO> checkParamsByMny(WorkTimeVO vo) {
        List productIds;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List list = vo.getWorkTimeDetailList();
        List resList = list.stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toMap(detail -> detail.getProjectId() + "-" + detail.getWbsId(), e -> e, (e1, e2) -> {
            e1.setCountTime(e1.getCountTime().add(e2.getCountTime()));
            return e1;
        })).values().stream().collect(Collectors.toList());
        List projectIds = list.stream().distinct().map(WorkTimeDetailVO::getProjectId).collect(Collectors.toList());
        CommonResponse targetData = this.targetApi.getLaborTimeByProjectIds(projectIds, productIds = list.stream().distinct().map(WorkTimeDetailVO::getWbsId).collect(Collectors.toList()));
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<String, BigDecimal> targetNumMap = targetDataList.stream().collect(Collectors.toMap(t -> t.getProjectId() + "-" + t.getProductId(), t -> t.getNum()));
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.in((Object)"project_id", projectIds)).in((Object)"wbs_id", productIds);
        if (null != vo.getId() && 0L != vo.getId()) {
            wrapper.ne((Object)"work_time_id", (Object)vo.getId());
        }
        List detailList = this.detailService.list((Wrapper)wrapper);
        HashMap<String, BigDecimal> totalNumMap = new HashMap<String, BigDecimal>();
        for (WorkTimeDetailEntity detail2 : detailList) {
            BigDecimal num = (BigDecimal)totalNumMap.get(detail2.getProjectId() + "-" + detail2.getWbsId());
            if (num == null) {
                totalNumMap.put(detail2.getProjectId() + "-" + detail2.getWbsId(), detail2.getCountTime());
                continue;
            }
            totalNumMap.put(detail2.getProjectId() + "-" + detail2.getWbsId(), num.add(detail2.getCountTime()));
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(GSJS_MNY_PARAM_CODE, vo.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List maxParamVOS = (List)billParamByCode.getData();
        this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u96f6\u4ef6\u4eba\u5de5\u5de5\u65f6\u3011\u7ba1\u63a7\u3010\u96f6\u4ef6\u5b9e\u9645\u751f\u4ea7\u5de5\u65f6\u3011\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        for (BillParamVO maxParamVO : maxParamVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
            ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
            for (WorkTimeDetailVO detail3 : resList) {
                BigDecimal targetTime = targetNumMap.get(detail3.getProjectId() + "-" + detail3.getWbsId()).setScale(2, 5);
                if (targetTime == null) continue;
                BigDecimal countTime = detail3.getCountTime().setScale(2, 5);
                BigDecimal totalTime = (BigDecimal)totalNumMap.get(detail3.getProjectId() + "-" + detail3.getWbsId());
                totalTime = totalTime == null ? countTime : totalTime.add(countTime);
                totalTime = ComputeUtil.safeDiv((BigDecimal)totalTime, (BigDecimal)BigDecimal.valueOf(60L)).setScale(2, 5);
                BigDecimal roleValue = maxParamVO.getRoleValue().setScale(2, 5);
                if (targetTime.multiply(maxParamVO.getRoleValue().divide(BigDecimal.valueOf(100L))).compareTo(totalTime) >= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u3010" + detail3.getProjectName() + "\u3011 + \u3010" + detail3.getWbsName() + "\u3011 \u751f\u4ea7\u5de5\u65f6\u8d85\u989d\u9884\u8b66");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u5de5\u65f6\u5927\u4e8e\u76ee\u6807\u5de5\u65f6");
                StringBuffer stringBuffer = new StringBuffer();
                String text = "\u8d85\u51fa\u5de5\u65f6=" + totalTime + "-" + targetTime + "*" + roleValue + "=" + totalTime.subtract(targetTime.multiply(roleValue.divide(BigDecimal.valueOf(100L)))).setScale(2, 5) + "\u5c0f\u65f6";
                String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                stringBuffer.append("\u7d2f\u8ba1\u751f\u4ea7\u5de5\u65f6\uff1a").append(totalTime).append("\u5c0f\u65f6").append("\uff0c\u76ee\u6807\u6210\u672c\u5de5\u65f6\uff1a").append(targetTime).append("\u5c0f\u65f6").append("\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOSMax.add(paramsCheckDsVO);
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);
        }
        return paramsCheckVOS;
    }
}

